/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.lang;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.JiraStringUtils;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class Pair<F, S> {
    private final F first;
    private final S second;

    public static <U, V> Pair<U, V> of(U first, V second) {
        return new Pair<U, V>(first, second);
    }

    private Pair(F first, S second) {
        this.first = Assertions.notNull("first", first);
        this.second = Assertions.notNull("second", second);
    }

    public F first() {
        return this.first;
    }

    public S second() {
        return this.second;
    }

    public int hashCode() {
        return this.first.hashCode() * 37 + this.second.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair that = (Pair)o;
        return this.first.equals(that.first) && this.second.equals(that.second);
    }

    public String toString() {
        return JiraStringUtils.asString("Pair[", "first=", this.first, ", second=", this.second, "]");
    }
}

