/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.opensymphony.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.util.UrlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MatchResult;

public class JiraKeyUtils {
    private static final Logger log = Logger.getLogger(JiraKeyUtils.class);
    public static final String STRIKE_THROUGH_CLOSED_KEYS = "strikeThroughClosedKeys";
    private static final String WINDOWS = "windows";
    private static volatile KeyMatcher keyMatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static KeyMatcher getKeyMatcher() {
        if (keyMatcher != null) return keyMatcher;
        Class<KeyMatcher> clazz = KeyMatcher.class;
        synchronized (KeyMatcher.class) {
            if (keyMatcher != null) return keyMatcher;
            keyMatcher = new ProductionKeyMatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return keyMatcher;
        }
    }

    static KeyMatcher getCurrentKeyMatcher() {
        return keyMatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetKeyMatcher() {
        Class<KeyMatcher> clazz = KeyMatcher.class;
        synchronized (KeyMatcher.class) {
            keyMatcher = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean validProjectKey(String key) {
        return JiraKeyUtils.getKeyMatcher().isValidProjectKey(key);
    }

    public static boolean isReservedKeyword(String key) {
        if (System.getProperty("os.name").compareToIgnoreCase(WINDOWS) >= 0) {
            ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
            String reservedKeywords = applicationProperties.getDefaultBackedString("jira.projectkey.reservedwords.list");
            StringTokenizer st = new StringTokenizer(reservedKeywords, ", ");
            while (st.hasMoreTokens()) {
                if (!key.equals(st.nextToken())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getProjectKeyFromIssueKey(String key) {
        if (!JiraKeyUtils.validIssueKey(key)) {
            return null;
        }
        return key.substring(0, key.lastIndexOf("-"));
    }

    public static String getFastProjectKeyFromIssueKey(String key) {
        try {
            return key.substring(0, key.lastIndexOf("-"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static long getFastCountFromKey(String key) {
        try {
            return Long.parseLong(key.substring(key.lastIndexOf("-") + 1));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static long getCountFromKey(String key) {
        long count;
        block3: {
            count = -1L;
            if (!JiraKeyUtils.validIssueKey(key)) {
                return count;
            }
            String countInKey = key.substring(key.lastIndexOf("-") + 1);
            try {
                count = Long.parseLong(countInKey);
            }
            catch (NumberFormatException nfe) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Count part of the key is not a number: '" + countInKey + "'"));
            }
        }
        return count;
    }

    public static boolean validIssueKey(String key) {
        return JiraKeyUtils.getKeyMatcher().isValidIssueKey(key);
    }

    public static boolean isKeyInString(String issueKey, String body) {
        if (StringUtils.isBlank((String)issueKey)) {
            throw new IllegalArgumentException("A valid key must be passed.");
        }
        if (StringUtils.isBlank((String)body)) {
            return false;
        }
        if (JiraKeyUtils.getKeyMatcher().isKeyDetectionBackwardsCompatible()) {
            return JiraKeyUtils.isKeyInStringBackwardsCompatible(issueKey, body);
        }
        return JiraKeyUtils.isKeyInStringMatchingRegex(issueKey, body);
    }

    private static boolean isKeyInStringBackwardsCompatible(String issueKey, String body) {
        int positionAfterKey;
        for (int startSearchIndex = 0; startSearchIndex < body.length(); startSearchIndex += positionAfterKey) {
            int index = body.indexOf(issueKey, startSearchIndex);
            if (index > -1) {
                positionAfterKey = index + issueKey.length();
                if (positionAfterKey == body.length()) {
                    return true;
                }
                char character = body.charAt(positionAfterKey);
                if (Character.isDigit(character)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isKeyInStringMatchingRegex(String issueKey, String body) {
        Perl5Util util = new Perl5Util();
        while (util.match(JiraKeyUtils.getKeyMatcher().getIssueKeyRegex(), body)) {
            MatchResult match = util.getMatch();
            int matchGroups = match.groups();
            String key = JiraKeyUtils.createKeyFromMatchingGroups(matchGroups, match);
            if (!(!issueKey.equals(key) || JiraKeyUtils.getKeyMatcher().isIgnoreUrlWithKey() && JiraKeyUtils.isPartOfUrl(body, match.beginOffset(2)))) {
                return true;
            }
            body = body.substring(match.endOffset(matchGroups - 1));
        }
        return false;
    }

    public static boolean isKeyInString(String s) {
        return JiraKeyUtils.getKeyMatcher().isKeyInString(s);
    }

    public static String linkBugKeys(String body) {
        if (StringUtils.isBlank((String)body)) {
            return "";
        }
        Perl5Util util = new Perl5Util();
        StringBuilder buff = new StringBuilder(body.length());
        while (util.match(JiraKeyUtils.getKeyMatcher().getIssueKeyRegex(), body)) {
            MatchResult match = util.getMatch();
            int matchGroups = match.groups();
            String key = JiraKeyUtils.createKeyFromMatchingGroups(matchGroups, match);
            int keyStart = match.beginOffset(2);
            if (JiraKeyUtils.isPartOfUrl(body, keyStart)) {
                int endIndex;
                boolean isInsideAnchor;
                boolean bl = isInsideAnchor = util.match("/<a[^>]*>(.*?" + key + ".*?)</a>/", body) && util.getMatch().beginOffset(0) < keyStart;
                if (isInsideAnchor) {
                    endIndex = util.getMatch().endOffset(0);
                    if (endIndex <= keyStart) {
                        log.error((Object)("Matched an anchor tag containing key '" + key + "' which ended before the key started!"));
                    }
                } else {
                    endIndex = JiraKeyUtils.getUrlEnd(body, match.beginOffset(2));
                }
                buff.append(body.substring(0, endIndex));
                body = body.substring(endIndex);
                continue;
            }
            buff.append(body.substring(0, match.beginOffset(2)));
            buff.append(JiraKeyUtils.getKeyMatcher().getLink(key));
            body = body.substring(match.endOffset(matchGroups - 1));
        }
        buff.append(body);
        return buff.toString();
    }

    public static List<String> getIssueKeysFromString(String body) {
        if (StringUtils.isBlank((String)body)) {
            return Collections.emptyList();
        }
        Perl5Util util = new Perl5Util();
        ArrayList<String> result = new ArrayList<String>();
        while (util.match(JiraKeyUtils.getKeyMatcher().getIssueKeyRegex(), body)) {
            MatchResult match = util.getMatch();
            int matchGroups = match.groups();
            if (!JiraKeyUtils.getKeyMatcher().isIgnoreUrlWithKey() || !JiraKeyUtils.isPartOfUrl(body, match.beginOffset(2))) {
                result.add(JiraKeyUtils.createKeyFromMatchingGroups(matchGroups, match));
            }
            body = body.substring(match.endOffset(matchGroups - 1));
        }
        return Collections.unmodifiableList(result);
    }

    private static String createKeyFromMatchingGroups(int matchGroups, MatchResult match) {
        StringBuffer sb = new StringBuffer();
        for (int i = 2; i < matchGroups; ++i) {
            sb.append(match.group(i));
        }
        return sb.toString();
    }

    public static boolean isPartOfUrl(String body, int start) {
        for (int i = start; i > 2; --i) {
            String s;
            if (body.charAt(i) == ' ') {
                return false;
            }
            if (body.charAt(i) != '/' || !(s = body.substring(i - 2, i)).equals(":/")) continue;
            return true;
        }
        return false;
    }

    static int getUrlEnd(String body, int start) {
        int i;
        for (i = start; i < body.length() && UrlUtils.isValidURLChar((char)body.charAt(i)); ++i) {
        }
        return i;
    }

    public static String getIssueKeyRegex() {
        return JiraKeyUtils.getKeyMatcher().getIssueKeyRegex();
    }

    static void setKeyMatcher(KeyMatcher keyMatcher) {
        JiraKeyUtils.keyMatcher = keyMatcher;
    }

    static class DefaultKeyMatcher
    implements KeyMatcher {
        private final Perl5Util perlUtil = new Perl5Util();
        private final String projectKeyRegex;
        private final String issueKeyRegex;

        DefaultKeyMatcher(String projectRegexp) {
            if (StringUtils.isNotBlank((String)projectRegexp)) {
                this.projectKeyRegex = "/^" + projectRegexp + "$/";
                this.issueKeyRegex = "/(^|[^a-zA-Z]|\n)" + projectRegexp + "(-[0-9]+)/";
            } else {
                this.projectKeyRegex = "/^[A-Z][A-Z]+$/";
                this.issueKeyRegex = "/(^|[^a-zA-Z]|\n)([A-Z][A-Z]+-[0-9]+)/";
            }
        }

        @Override
        public boolean isKeyInString(String s) {
            return this.perlUtil.match(this.getIssueKeyRegex(), s);
        }

        @Override
        public String getProjectKeyRegex() {
            return this.projectKeyRegex;
        }

        @Override
        public String getIssueKeyRegex() {
            return this.issueKeyRegex;
        }

        @Override
        public boolean isValidIssueKey(String issueKey) {
            if (issueKey == null) {
                return false;
            }
            int hyphenLocation = issueKey.lastIndexOf(45);
            if (hyphenLocation > 0) {
                String projectKey = issueKey.substring(0, hyphenLocation);
                String issueNumber = issueKey.substring(hyphenLocation + 1);
                if (JiraKeyUtils.validProjectKey(projectKey)) {
                    char[] chars;
                    if (issueNumber.length() == 0) {
                        return false;
                    }
                    for (char c : chars = issueNumber.toCharArray()) {
                        if (Character.isDigit(c)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public boolean isValidProjectKey(String projectKey) {
            if (StringUtils.isBlank((String)projectKey)) {
                return false;
            }
            return this.perlUtil.match(this.getProjectKeyRegex(), projectKey);
        }

        @Override
        public boolean isIgnoreUrlWithKey() {
            return true;
        }

        @Override
        public boolean isKeyDetectionBackwardsCompatible() {
            return false;
        }

        @Override
        public String getLink(String key) {
            return key;
        }
    }

    static class ProductionKeyMatcher
    extends DefaultKeyMatcher {
        ProductionKeyMatcher() {
            super(ComponentAccessor.getApplicationProperties().getDefaultBackedString("jira.projectkey.pattern"));
        }

        ProductionKeyMatcher(String projectRegexp) {
            super(projectRegexp);
        }

        @Override
        public boolean isIgnoreUrlWithKey() {
            return Boolean.valueOf(this.getApplicationProperties().getDefaultBackedString("jira.option.ignore.url.with.key"));
        }

        @Override
        public boolean isKeyDetectionBackwardsCompatible() {
            return Boolean.valueOf(this.getApplicationProperties().getDefaultBackedString("jira.option.key.detection.backwards.compatible"));
        }

        @Override
        public String getLink(String key) {
            StringBuilder buff = new StringBuilder();
            try {
                MutableIssue issue = this.getIssueManager().getIssueObject(key);
                if (issue != null && this.canCurrentUserSeeIssue(issue)) {
                    String title = TextUtils.htmlEncode((String)issue.getSummary());
                    VelocityRequestContext velocityRequestContext = ComponentAccessor.getComponent(VelocityRequestContextFactory.class).getJiraVelocityRequestContext();
                    buff.append("<a href=\"").append(velocityRequestContext.getBaseUrl()).append("/browse/").append(issue.getKey()).append("\" title=\"").append(title).append("\">");
                    if (issue.getResolutionObject() != null) {
                        buff.append("<strike>");
                        buff.append(key);
                        buff.append("</strike>");
                    } else {
                        buff.append(key);
                    }
                    buff.append("</a>");
                } else {
                    buff.append(key);
                }
            }
            catch (Exception e) {
                buff.append(key);
            }
            return buff.toString();
        }

        boolean canCurrentUserSeeIssue(Issue issue) {
            User user = ComponentAccessor.getJiraAuthenticationContext().getUser();
            return ComponentAccessor.getPermissionManager().hasPermission(10, issue, user);
        }

        ApplicationProperties getApplicationProperties() {
            return ComponentAccessor.getApplicationProperties();
        }

        IssueManager getIssueManager() {
            return ComponentAccessor.getIssueManager();
        }
    }

    public static interface KeyMatcher {
        public String getProjectKeyRegex();

        public String getIssueKeyRegex();

        public boolean isKeyInString(String var1);

        public boolean isValidProjectKey(String var1);

        public boolean isValidIssueKey(String var1);

        public boolean isIgnoreUrlWithKey();

        public boolean isKeyDetectionBackwardsCompatible();

        public String getLink(String var1);
    }
}

