/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.JiraKeyUtils;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ServiceUtils {
    private static final String INVALID_ISSUEKEY_CHARS = "\n\r\t \"''`~,.:;<>()[]{}!@#$%^&*+=|\\/?";
    private static final Logger log = Logger.getLogger(ServiceUtils.class);

    private ServiceUtils() {
    }

    public static GenericValue getProject(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, INVALID_ISSUEKEY_CHARS, false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!JiraKeyUtils.validProjectKey(token)) continue;
            GenericValue project = ComponentAccessor.getProjectManager().getProjectByKey(token);
            return project;
        }
        return null;
    }

    public static GenericValue getIssue(String key) {
        GenericValue issue = null;
        try {
            Issue movedIssue;
            issue = ComponentAccessor.getIssueManager().getIssue(key);
            if (issue == null && (movedIssue = ComponentAccessor.getChangeHistoryManager().findMovedIssue(key)) != null) {
                issue = movedIssue.getGenericValue();
            }
        }
        catch (GenericEntityException e) {
            log.warn((Object)("Error getting issue from key [" + key + "]: " + e.getMessage()), (Throwable)e);
        }
        return issue;
    }

    public static GenericValue findIssueInString(String searchString) {
        StringTokenizer tokenizer = new StringTokenizer(TextUtils.noNull((String)searchString).toUpperCase(), INVALID_ISSUEKEY_CHARS, false);
        while (tokenizer.hasMoreTokens()) {
            GenericValue issue;
            String token = tokenizer.nextToken();
            if (!JiraKeyUtils.validIssueKey(token) || (issue = ServiceUtils.getIssue(token)) == null) continue;
            return issue;
        }
        return null;
    }

    public static GenericValue[] findIssuesInString(String searchString) {
        if (searchString == null) {
            return null;
        }
        ArrayList<GenericValue> al = new ArrayList<GenericValue>();
        StringTokenizer tokenizer = new StringTokenizer(searchString, INVALID_ISSUEKEY_CHARS, false);
        while (tokenizer.hasMoreTokens()) {
            GenericValue issue;
            String token = tokenizer.nextToken();
            if (!JiraKeyUtils.validIssueKey(token) || (issue = ServiceUtils.getIssue(token)) == null) continue;
            al.add(issue);
        }
        return al.toArray(new GenericValue[al.size()]);
    }

    public static Map<String, String> getParameterMap(String parameterString) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (parameterString != null) {
            StringTokenizer st = new StringTokenizer(parameterString, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int equalIdx = token.indexOf(61);
                if (equalIdx < 0) continue;
                String paramName = token.substring(0, equalIdx);
                String paramValue = null;
                if (equalIdx + 1 < token.length()) {
                    paramValue = token.substring(equalIdx + 1);
                }
                params.put(paramName, paramValue);
            }
        }
        return params;
    }
}

