/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public abstract class AbstractCustomFieldIndexer
implements FieldIndexer {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final CustomField customField;

    protected AbstractCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.customField = customField;
    }

    @Override
    public String getId() {
        return this.customField.getId();
    }

    @Override
    public String getDocumentFieldId() {
        return this.customField.getId();
    }

    public abstract void addDocumentFieldsSearchable(Document var1, Issue var2);

    public abstract void addDocumentFieldsNotSearchable(Document var1, Issue var2);

    @Override
    public final void addIndex(Document doc, Issue issue) {
        if (this.isFieldVisibleAndInScope(issue)) {
            this.addDocumentFieldsSearchable(doc, issue);
        } else {
            this.addDocumentFieldsNotSearchable(doc, issue);
        }
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.isRelevantForIssue(issue) && !this.fieldVisibilityManager.isFieldHidden(this.getId(), issue);
    }

    protected boolean isRelevantForIssue(Issue issue) {
        return this.customField.getRelevantConfig(issue) != null;
    }
}

