/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.crowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.google.common.collect.Lists;
import com.opensymphony.user.provider.CredentialsProvider;
import com.opensymphony.user.provider.crowd.EmbeddedCrowdAbstractProvider;
import java.util.Collections;
import java.util.List;

public class EmbeddedCrowdCredentialsProvider
extends EmbeddedCrowdAbstractProvider
implements CredentialsProvider {
    private static final String DEFAULT_BLANK = "";

    @Override
    public boolean authenticate(String name, String password) {
        try {
            User user = this.getCrowdService().authenticate(name, password);
            return user != null;
        }
        catch (CrowdException e) {
            this.logger.info("User failed to authenticate");
            return false;
        }
        catch (UserNotFoundException e) {
            this.logger.info("User not found");
            return false;
        }
    }

    @Override
    public boolean changePassword(String name, String password) {
        CrowdService crowdService = this.getCrowdService();
        try {
            User user = crowdService.getUser(name);
            if (user != null) {
                crowdService.updateUserCredential(user, password);
                return true;
            }
            this.logger.error("Could not change password");
            return false;
        }
        catch (CrowdException e) {
            this.logger.error("Could not change password", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean create(String name) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating user: " + name);
            }
            UserTemplate template = new UserTemplate(name);
            template.setActive(true);
            template.setEmailAddress(DEFAULT_BLANK);
            template.setFirstName(DEFAULT_BLANK);
            template.setLastName(DEFAULT_BLANK);
            template.setDisplayName(DEFAULT_BLANK);
            this.getCrowdService().addUser((User)template, DEFAULT_BLANK);
            return true;
        }
        catch (CrowdException e) {
            this.logger.error("Error creating user : " + name + " : " + (Object)((Object)e), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean handles(String name) {
        if (name == null) {
            return false;
        }
        try {
            User user = this.getCrowdService().getUser(name);
            return user != null;
        }
        catch (Exception e) {
            this.logger.error("Could not determine if we handle: " + name, (Throwable)e);
            return false;
        }
    }

    @Override
    public List<String> list() {
        Iterable userNames = this.getCrowdService().search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
        return Collections.unmodifiableList(Lists.newArrayList((Iterable)userNames));
    }

    @Override
    public boolean remove(String name) {
        CrowdService crowdService = this.getCrowdService();
        try {
            User user = crowdService.getUser(name);
            if (user != null) {
                crowdService.removeUser(user);
                return true;
            }
            this.logger.error("Could not remove user: " + name);
            return false;
        }
        catch (CrowdException e) {
            this.logger.error("Could not remove user: " + name, (Throwable)e);
            return false;
        }
    }
}

