/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NotNull;
import com.atlassian.util.concurrent.Nullable;
import com.opensymphony.user.ImmutableException;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import org.ofbiz.core.entity.GenericValue;

public interface UserUtil {
    public static final String META_PROPERTY_PREFIX = "jira.meta.";

    public int getTotalUserCount();

    @NotNull
    public Set<com.opensymphony.user.User> getAllUsers();

    @NotNull
    public Collection<User> getUsers();

    public com.opensymphony.user.Group getGroup(@Nullable String var1);

    public Group getGroupObject(@Nullable String var1);

    public com.opensymphony.user.User createUserWithEvent(String var1, String var2, String var3, String var4, int var5) throws ImmutableException;

    public User createUserWithNotification(String var1, String var2, String var3, String var4, int var5) throws PermissionException, CreateException;

    public com.opensymphony.user.User createUserNoEvent(String var1, String var2, String var3, String var4) throws ImmutableException;

    public User createUserNoNotification(String var1, String var2, String var3, String var4) throws PermissionException, CreateException;

    public void removeUser(User var1, User var2);

    public void removeUser(com.opensymphony.user.User var1, com.opensymphony.user.User var2, I18nHelper var3);

    public void addUserToGroup(Group var1, User var2) throws PermissionException, AddException;

    public void addUserToGroup(com.opensymphony.user.Group var1, com.opensymphony.user.User var2);

    public void addUserToGroups(Collection<com.opensymphony.user.Group> var1, com.opensymphony.user.User var2);

    public void addUserToGroups(Collection<Group> var1, User var2) throws PermissionException, AddException;

    public void removeUserFromGroup(com.opensymphony.user.Group var1, com.opensymphony.user.User var2);

    public void removeUserFromGroup(Group var1, User var2) throws PermissionException, RemoveException;

    public void removeUserFromGroups(Collection<com.opensymphony.user.Group> var1, com.opensymphony.user.User var2);

    public void removeUserFromGroups(Collection<Group> var1, User var2) throws PermissionException, RemoveException;

    public PasswordResetToken generatePasswordResetToken(User var1);

    public PasswordResetToken generatePasswordResetToken(com.opensymphony.user.User var1);

    public PasswordResetTokenValidation validatePasswordResetToken(User var1, String var2);

    public void changePassword(com.opensymphony.user.User var1, String var2) throws ImmutableException;

    public void changePassword(User var1, String var2) throws UserNotFoundException, InvalidCredentialException, OperationNotPermittedException, PermissionException;

    public int getActiveUserCount();

    public void clearActiveUserCount();

    public boolean hasExceededUserLimit();

    public boolean canActivateNumberOfUsers(int var1);

    public boolean canActivateUsers(Collection<String> var1);

    public com.opensymphony.user.User getUser(String var1);

    public User getUserObject(String var1);

    public boolean userExists(String var1);

    public Collection<com.opensymphony.user.User> getAdministrators();

    public Collection<User> getJiraAdministrators();

    public Collection<com.opensymphony.user.User> getSystemAdministrators();

    public Collection<User> getJiraSystemAdministrators();

    public void addToJiraUsePermission(com.opensymphony.user.User var1);

    public void addToJiraUsePermission(User var1) throws PermissionException;

    public Collection<ProjectComponent> getComponentsUserLeads(com.opensymphony.user.User var1);

    public Collection<ProjectComponent> getComponentsUserLeads(User var1);

    public Collection<GenericValue> getProjectsUserLeads(com.opensymphony.user.User var1);

    public Collection<Project> getProjectsLeadBy(User var1);

    public boolean isNonSysAdminAttemptingToDeleteSysAdmin(com.opensymphony.user.User var1, com.opensymphony.user.User var2);

    public boolean isNonSysAdminAttemptingToDeleteSysAdmin(User var1, User var2);

    public long getNumberOfReportedIssuesIgnoreSecurity(User var1, User var2) throws SearchException;

    public long getNumberOfReportedIssuesIgnoreSecurity(com.opensymphony.user.User var1, com.opensymphony.user.User var2) throws SearchException;

    public long getNumberOfAssignedIssuesIgnoreSecurity(User var1, User var2) throws SearchException;

    public long getNumberOfAssignedIssuesIgnoreSecurity(com.opensymphony.user.User var1, com.opensymphony.user.User var2) throws SearchException;

    public String getDisplayableNameSafely(User var1);

    public String getDisplayableNameSafely(com.opensymphony.user.User var1);

    public SortedSet<Group> getGroupsForUser(String var1);

    public SortedSet<String> getGroupNamesForUser(String var1);

    public SortedSet<User> getAllUsersInGroupNames(Collection<String> var1);

    public SortedSet<com.opensymphony.user.User> getUsersInGroupNames(Collection<String> var1);

    public SortedSet<User> getAllUsersInGroups(Collection<Group> var1);

    public SortedSet<com.opensymphony.user.User> getUsersInGroups(Collection<com.opensymphony.user.Group> var1);

    public static interface PasswordResetTokenValidation {
        public Status getStatus();

        public static enum Status {
            EXPIRED,
            UNEQUAL,
            OK;

        }
    }

    public static interface PasswordResetToken {
        public User getUser();

        public String getToken();

        public int getExpiryHours();

        public long getExpiryTime();
    }
}

