/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.util.concurrent.Assertions;

class TransformingEnclosedIterable<I, O>
implements EnclosedIterable<O> {
    private final EnclosedIterable<I> delegate;
    private final Function<I, O> transformer;

    TransformingEnclosedIterable(@NotNull EnclosedIterable<I> delegate, @NotNull Function<I, O> transformer) {
        this.delegate = (EnclosedIterable)Assertions.notNull((String)"delegate", delegate);
        this.transformer = (Function)Assertions.notNull((String)"decorator", transformer);
    }

    @Override
    public void foreach(final Consumer<O> sink) {
        this.delegate.foreach(new Consumer<I>(){

            @Override
            public void consume(I element) {
                sink.consume(TransformingEnclosedIterable.this.transformer.get(element));
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

