/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.clause;

import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.google.common.base.Objects;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@ExperimentalSearchApi
public class MultiWorklogClause
implements Clause {
    public static final String NAME = "WORKLOG";
    private final List<Clause> clauses;
    private final Operator operator;

    public MultiWorklogClause(Operator operator, Clause ... clauses) {
        this(operator, List.of(clauses));
    }

    public MultiWorklogClause(Operator operator, List<Clause> clauses) {
        this.operator = Assertions.notNull("operator", operator);
        this.clauses = Assertions.notNull("clauses", clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<Clause> getClauses() {
        return this.clauses;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public <R> R accept(ClauseVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", NAME, StringUtils.join(this.clauses, (String)(" " + this.operator.name() + " ")));
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiWorklogClause)) {
            return false;
        }
        MultiWorklogClause that = (MultiWorklogClause)o;
        return Objects.equal(this.clauses, that.clauses) && this.operator == that.operator;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clauses, this.operator});
    }

    public static enum Operator {
        OR,
        AND;

    }
}

