/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ShareQueryFactory;
import com.atlassian.jira.sharing.type.ShareTypePermissionChecker;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nonnull;

@Internal
public interface ShareType {
    public Name getType();

    public boolean isSingleton();

    public int getPriority();

    public ShareTypeRenderer getRenderer();

    public ShareTypeValidator getValidator();

    public ShareTypePermissionChecker getPermissionsChecker();

    public ShareQueryFactory<? extends ShareTypeSearchParameter> getQueryFactory();

    public Comparator<SharePermission> getComparator();

    default public boolean isAvailable() {
        return true;
    }

    @Nonnull
    default public Collection<UsageContextType> getValidUsageContextTypes() {
        return Collections.emptyList();
    }

    public static enum UsageContextType {
        VIEW,
        VIEW_EDIT;

    }

    public static final class Name {
        public static final Name USER = new Name("user");
        public static final Name GLOBAL = new Name("global");
        public static final Name AUTHENTICATED = new Name("loggedin");
        public static final Name PROJECT = new Name("project");
        public static final Name GROUP = new Name("group");
        public static final Name PROJECT_UNKNOWN = new Name("project-unknown");
        public static final Name USER_UNKNOWN = new Name("user-unknown");
        public static final Name GROUP_UNKNOWN = new Name("group-unknown");
        private final String name;

        public Name(String name) {
            Assertions.notBlank("name", name);
            this.name = name;
        }

        public String get() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Name other = (Name)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return this.name;
        }
    }
}

