/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.request;

import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.QuerySort;
import com.atlassian.jira.search.aggregation.Aggregation;
import com.atlassian.jira.search.aggregation.AggregationsRequest;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.request.AbstractSearchRequestBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

@ExperimentalSearchApi
public class SearchRequest {
    private final Set<String> fields;
    private final Query query;
    private final QuerySort sort;
    private final String documentType;
    private final AggregationsRequest aggregations;

    private SearchRequest(Builder builder) {
        this.fields = builder.fields;
        this.query = builder.query;
        this.sort = builder.sort;
        this.documentType = builder.documentType;
        this.aggregations = builder.aggregations.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Query query) {
        return new Builder(query);
    }

    @Nullable
    public Set<String> getFields() {
        return this.fields;
    }

    public Query getQuery() {
        return this.query;
    }

    public Optional<QuerySort> getSort() {
        return Optional.ofNullable(this.sort);
    }

    public AggregationsRequest getAggregations() {
        return this.aggregations;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SearchRequest that = (SearchRequest)obj;
        return Objects.equals(this.query, that.query) && Objects.equals(this.sort, that.sort) && Objects.equals(this.fields, that.fields) && Objects.equals(this.documentType, that.documentType) && Objects.equals(this.aggregations, that.aggregations);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.query, this.sort, this.documentType, this.aggregations);
    }

    public static class Builder
    extends AbstractSearchRequestBuilder<Builder> {
        private Query query;
        private QuerySort sort;
        private final AggregationsRequest.Builder aggregations = AggregationsRequest.builder();

        public Builder() {
        }

        public Builder(Query query) {
            this();
            this.query = Objects.requireNonNull(query, "query");
        }

        public SearchRequest build() {
            Objects.requireNonNull(this.query, "Query is required");
            Objects.requireNonNull(this.documentType, "DocumentType is required");
            return new SearchRequest(this);
        }

        public Builder query(Query value) {
            this.query = Objects.requireNonNull(value, "query");
            return this.self();
        }

        public Builder sort(@Nullable QuerySort value) {
            this.sort = value;
            return this.self();
        }

        public Builder aggregation(String name, Aggregation aggregation) {
            this.aggregations.put(name, aggregation);
            return this.self();
        }

        public Builder aggregations(Map<String, Aggregation> values) {
            this.aggregations.putAll(values);
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

