/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.query;

import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.query.Operator;
import com.atlassian.jira.search.query.QueryStringQuery;
import java.util.Objects;

@ExperimentalSearchApi
public final class DefaultQueryStringQuery
implements QueryStringQuery {
    private final String field;
    private final String text;
    private final Operator defaultOperator;

    public DefaultQueryStringQuery(String field, String text) {
        this(field, text, Operator.OR);
    }

    public DefaultQueryStringQuery(String field, String text, Operator defaultOperator) {
        this.field = Objects.requireNonNull(field);
        this.text = Objects.requireNonNull(text);
        this.defaultOperator = Objects.requireNonNull(defaultOperator);
    }

    @Override
    public String field() {
        return this.field;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public Operator defaultOperator() {
        return this.defaultOperator;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultQueryStringQuery that = (DefaultQueryStringQuery)obj;
        return Objects.equals(this.field, that.field) && Objects.equals((Object)this.defaultOperator, (Object)that.defaultOperator) && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.text, this.defaultOperator});
    }

    public String toString() {
        return "DefaultQueryStringQuery[defaultOperator=" + String.valueOf((Object)this.defaultOperator) + ", field=" + this.field + ", text=" + this.text + "]";
    }
}

