/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.query;

import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.query.PrefixQuery;
import com.atlassian.jira.search.query.RewriteMode;
import java.util.Objects;

@ExperimentalSearchApi
public final class DefaultPrefixQuery
implements PrefixQuery {
    private final String field;
    private final String value;
    private final RewriteMode rewriteMode;

    public DefaultPrefixQuery(String field, String value, RewriteMode rewriteMode) {
        this.field = Objects.requireNonNull(field);
        this.value = Objects.requireNonNull(value);
        this.rewriteMode = Objects.requireNonNull(rewriteMode);
    }

    public DefaultPrefixQuery(String field, String value) {
        this(field, value, RewriteMode.CONSTANT_SCORE);
    }

    @Override
    public String field() {
        return this.field;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public RewriteMode rewriteMode() {
        return this.rewriteMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPrefixQuery that = (DefaultPrefixQuery)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.value, that.value) && this.rewriteMode == that.rewriteMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.value, this.rewriteMode});
    }

    public String toString() {
        return "DefaultPrefixQuery{field=" + this.field + ", value='" + this.value + "', rewriteMode=" + String.valueOf((Object)this.rewriteMode) + "}";
    }
}

