/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.query;

import com.atlassian.jira.search.annotations.ExperimentalSearchSpi;
import com.atlassian.jira.search.query.RangeQuery;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@ExperimentalSearchSpi
public abstract class AbstractRangeQuery<T>
implements RangeQuery<T> {
    private final String field;
    private final T lower;
    private final T upper;
    private final boolean includeLower;
    private final boolean includeUpper;

    protected AbstractRangeQuery(String field, @Nullable T lower, @Nullable T upper) {
        this(field, lower, upper, true, true);
    }

    protected AbstractRangeQuery(String field, @Nullable T lower, @Nullable T upper, boolean includeLower, boolean includeUpper) {
        Assertions.is("'includeLower' must be true if 'lower' is null", lower != null || includeLower);
        Assertions.is("'includeUpper' must be true if 'upper' is null", upper != null || includeUpper);
        this.field = Objects.requireNonNull(field);
        this.lower = lower;
        this.upper = upper;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    @Override
    public String field() {
        return this.field;
    }

    @Override
    public Optional<T> lower() {
        return Optional.ofNullable(this.lower);
    }

    @Override
    public Optional<T> upper() {
        return Optional.ofNullable(this.upper);
    }

    @Override
    public boolean includeLower() {
        return this.includeLower;
    }

    @Override
    public boolean includeUpper() {
        return this.includeUpper;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractRangeQuery that = (AbstractRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Objects.equals(this.lower, that.lower) && Objects.equals(this.upper, that.upper) && this.includeLower == that.includeLower && this.includeUpper == that.includeUpper;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.lower, this.upper, this.includeLower, this.includeUpper);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[field=" + this.field + ", lower=" + String.valueOf(this.lower) + ", upper=" + String.valueOf(this.upper) + ", includeLower=" + this.includeLower + ", includeUpper=" + this.includeUpper + "]";
    }
}

