/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.AbstractOperatorQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.jira.util.Predicate;
import com.atlassian.query.operator.Operator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class RelationalOperatorIdIndexValueQueryFactory<T>
extends AbstractOperatorQueryFactory<T>
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(RelationalOperatorIdIndexValueQueryFactory.class);
    private final Comparator<? super T> comparator;
    private final NameResolver<T> resolver;
    private final IndexInfoResolver<T> indexInfoResolver;

    public RelationalOperatorIdIndexValueQueryFactory(Comparator<? super T> comparator, NameResolver<T> resolver, IndexInfoResolver<T> indexInfoResolver) {
        super(indexInfoResolver);
        this.indexInfoResolver = Objects.requireNonNull(indexInfoResolver);
        this.comparator = Objects.requireNonNull(comparator);
        this.resolver = Objects.requireNonNull(resolver);
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            log.debug("Create query for single value was called with operator '{}', this only handles relational operators.", (Object)operator.getDisplayString());
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        DefaultBooleanQuery.Builder result = new DefaultBooleanQuery.Builder();
        List<Query> subqueries = this.getIndexValues(rawValues).stream().filter(Objects::nonNull).map(id -> this.generateQueryForValue(fieldName, operator, (String)id)).filter(query -> !DefaultMatchNoDocsQuery.INSTANCE.equals(query)).toList();
        if (subqueries.isEmpty()) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        if (subqueries.size() == 1) {
            return subqueries.get(0);
        }
        subqueries.forEach(query -> result.add((Query)query, BooleanQuery.Occur.SHOULD));
        return result.build();
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.debug("Empty operands are not supported by this query factory.");
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> listOfIds) {
        log.debug("Multi value operands are not supported by this query factory.");
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }

    Query generateQueryForValue(String fieldName, Operator operator, String indexValue) {
        Long id = this.getValueAsLong(indexValue);
        T domainObject = this.resolver.get(id);
        Predicate<T> relationalOperatorMatch = this.createPredicate(operator, domainObject);
        return this.generateRangeQueryForPredicate(fieldName, relationalOperatorMatch);
    }

    Predicate<T> createPredicate(Operator operator, T domainObject) {
        return operator.getPredicateForValue(this.comparator, domainObject);
    }

    protected Query generateRangeQueryForPredicate(String fieldName, Predicate<T> match) {
        DefaultBooleanQuery.Builder bq = new DefaultBooleanQuery.Builder();
        this.resolver.getAll().stream().filter(match::evaluate).forEach(indexedObject -> bq.add(this.getTermQuery(fieldName, this.indexInfoResolver.getIndexedValue(indexedObject)), BooleanQuery.Occur.SHOULD));
        BooleanQuery query = bq.build();
        if (query.clauses().isEmpty()) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        return bq.build();
    }

    @Nullable
    private Long getValueAsLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

