/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.lucenelegacy.NumericUtils;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.AbstractNumberOperatorQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.jql.RangeQueryFactory;
import com.atlassian.jira.search.jql.TermQueryFactory;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.query.operator.Operator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class NumberRelationalQueryFactory
extends AbstractNumberOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(NumberRelationalQueryFactory.class);
    private static final RangeQueryFactory<String> RANGE_QUERY_FACTORY = RangeQueryFactory.stringRangeQueryFactory();

    public NumberRelationalQueryFactory(DoubleConverter doubleConverter) {
        super(doubleConverter);
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            log.debug("ActualValueRelationalQueryFactory does not support operator '{}'.", (Object)operator.getDisplayString());
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        List<Double> values = this.getIndexValues(rawValues);
        if (values.isEmpty()) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        Double value = values.get(0);
        if (value == null) {
            log.debug("Relation operators do not support empty values");
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        Query query = RANGE_QUERY_FACTORY.get(operator, "sort_" + fieldName, NumericUtils.doubleToPrefixCoded((double)value));
        DefaultBooleanQuery.Builder combined = new DefaultBooleanQuery.Builder();
        combined.add(TermQueryFactory.nonEmptyQuery(fieldName), BooleanQuery.Occur.MUST);
        combined.add(query, BooleanQuery.Occur.MUST);
        query = combined.build();
        return query;
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        log.debug("Relation operators do not support multivalue operands");
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.debug("Relation operators do not support multivalue empty");
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

