/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.issue.search.util.TextTermEscaper;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.jql.TermQueryFactory;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.jira.search.query.DefaultQueryStringQuery;
import com.atlassian.jira.search.query.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class LikeQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(LikeQueryFactory.class);
    private final boolean usesMainIndex;

    public LikeQueryFactory() {
        this.usesMainIndex = true;
    }

    public LikeQueryFactory(boolean usesMainIndex) {
        this.usesMainIndex = usesMainIndex;
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, com.atlassian.query.operator.Operator operator, List<QueryLiteral> rawValues) {
        if (operator != com.atlassian.query.operator.Operator.LIKE && operator != com.atlassian.query.operator.Operator.NOT_LIKE) {
            log.debug("Operator '{}' is not a LIKE operator.", (Object)operator.getDisplayString());
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        return this.createResult(fieldName, rawValues, operator, this.usesMainIndex);
    }

    public Query createResult(String fieldName, List<QueryLiteral> rawValues, com.atlassian.query.operator.Operator operator, boolean handleEmpty) {
        List<Query> queries = this.getQueries(fieldName, rawValues);
        if (queries.isEmpty()) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        if (queries.size() == 1) {
            return this.handleSingleQuery(fieldName, operator, handleEmpty, queries.get(0));
        }
        DefaultBooleanQuery.Builder fullQuery = new DefaultBooleanQuery.Builder();
        DefaultBooleanQuery.Builder subQuery = new DefaultBooleanQuery.Builder();
        boolean hasEmpty = queries.stream().anyMatch(Objects::isNull);
        for (Query query : queries) {
            if (query == null) continue;
            subQuery.add(query, operator == com.atlassian.query.operator.Operator.NOT_LIKE ? BooleanQuery.Occur.MUST_NOT : BooleanQuery.Occur.SHOULD);
        }
        if (handleEmpty && hasEmpty) {
            subQuery.add(this.createQueryForEmptyOperand(fieldName, operator), operator == com.atlassian.query.operator.Operator.NOT_LIKE ? BooleanQuery.Occur.MUST : BooleanQuery.Occur.SHOULD);
        }
        fullQuery.add(subQuery.build(), BooleanQuery.Occur.MUST);
        if (handleEmpty && !hasEmpty) {
            fullQuery.add(TermQueryFactory.nonEmptyQuery(fieldName), BooleanQuery.Occur.FILTER);
            fullQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanQuery.Occur.FILTER);
        }
        return fullQuery.build();
    }

    private Query handleSingleQuery(String fieldName, com.atlassian.query.operator.Operator operator, boolean handleEmpty, @Nullable Query query) {
        if (handleEmpty) {
            if (query == null) {
                return this.createQueryForEmptyOperand(fieldName, operator);
            }
            return new DefaultBooleanQuery.Builder().add(query, operator == com.atlassian.query.operator.Operator.NOT_LIKE ? BooleanQuery.Occur.MUST_NOT : BooleanQuery.Occur.MUST).add(TermQueryFactory.nonEmptyQuery(fieldName), BooleanQuery.Occur.FILTER).add(TermQueryFactory.visibilityQuery(fieldName), BooleanQuery.Occur.FILTER).build();
        }
        if (query == null) {
            return DefaultMatchNoDocsQuery.INSTANCE;
        }
        return com.atlassian.query.operator.Operator.NOT_LIKE == operator ? DefaultBooleanQuery.mustNot(query) : query;
    }

    protected List<Query> getQueries(String fieldName, List<QueryLiteral> rawValues) {
        ArrayList queries = Lists.newArrayListWithCapacity((int)rawValues.size());
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.isEmpty()) {
                queries.add(null);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)rawValue.asString())) continue;
            String value = this.getEscapedValueFromRawValues(rawValue);
            DefaultQueryStringQuery query = new DefaultQueryStringQuery(fieldName, value, Operator.AND);
            queries.add(query);
        }
        return queries;
    }

    @Override
    public Query createQueryForEmptyOperand(String fieldName, com.atlassian.query.operator.Operator operator) {
        if (operator == com.atlassian.query.operator.Operator.IS || operator == com.atlassian.query.operator.Operator.LIKE) {
            return TermQueryFactory.emptyQuery(fieldName);
        }
        if (operator == com.atlassian.query.operator.Operator.IS_NOT || operator == com.atlassian.query.operator.Operator.NOT_LIKE) {
            return TermQueryFactory.nonEmptyQuery(fieldName);
        }
        if (log.isDebugEnabled()) {
            log.debug("Create query for empty operand was called with operator '{}', this only handles '=', '!=', 'is' and 'not is'.", (Object)operator.getDisplayString());
        }
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    private String getEscapedValueFromRawValues(QueryLiteral rawValue) {
        return TextTermEscaper.escape(rawValue.asString());
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, com.atlassian.query.operator.Operator operator, List<QueryLiteral> rawValues) {
        log.debug("LIKE clauses do not support multi value operands.");
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public boolean handlesOperator(com.atlassian.query.operator.Operator operator) {
        return OperatorClasses.TEXT_OPERATORS.contains((Object)operator);
    }
}

