/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchSpi;
import com.atlassian.jira.util.Function;
import com.atlassian.query.operator.Operator;
import java.util.Objects;

@ExperimentalSearchSpi
public abstract class AbstractRangeQueryFactory<T, U> {
    protected final Function<T, U> valueFactory;

    protected AbstractRangeQueryFactory(Function<T, U> valueFactory) {
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    Query get(Operator operator, String fieldName, T value) {
        return switch (operator) {
            case Operator.LESS_THAN -> this.handleLessThan(fieldName, value);
            case Operator.LESS_THAN_EQUALS -> this.handleLessThanEquals(fieldName, value);
            case Operator.GREATER_THAN -> this.handleGreaterThan(fieldName, value);
            case Operator.GREATER_THAN_EQUALS -> this.handleGreaterThanEquals(fieldName, value);
            default -> throw new IllegalArgumentException("Unhandled Operator: " + String.valueOf((Object)operator));
        };
    }

    abstract Query handleLessThan(String var1, T var2);

    abstract Query handleLessThanEquals(String var1, T var2);

    abstract Query handleGreaterThan(String var1, T var2);

    abstract Query handleGreaterThanEquals(String var1, T var2);

    abstract Query handleDuring(String var1, T var2, T var3);
}

