/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.search.annotations.ExperimentalSearchSpi;
import com.atlassian.jira.search.query.DefaultTermQuery;
import com.atlassian.jira.search.query.TermQuery;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@ExperimentalSearchSpi
public abstract class AbstractOperatorQueryFactory<T> {
    private final IndexInfoResolver<T> indexInfoResolver;

    protected AbstractOperatorQueryFactory(IndexInfoResolver<T> indexInfoResolver) {
        this.indexInfoResolver = Objects.requireNonNull(indexInfoResolver);
    }

    protected TermQuery getTermQuery(String fieldName, String indexValue) {
        return new DefaultTermQuery(fieldName, indexValue);
    }

    List<String> getIndexValues(List<QueryLiteral> rawValues) {
        if (rawValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList indexValues = Lists.newArrayListWithCapacity((int)rawValues.size());
        for (QueryLiteral rawValue : rawValues) {
            List<String> vals;
            if (rawValue == null) continue;
            if (rawValue.getStringValue() != null) {
                vals = this.indexInfoResolver.getIndexedValues(rawValue.getStringValue());
            } else if (rawValue.getLongValue() != null) {
                vals = this.indexInfoResolver.getIndexedValues(rawValue.getLongValue());
            } else {
                indexValues.add(null);
                continue;
            }
            if (vals == null || vals.isEmpty()) continue;
            indexValues.addAll(vals);
        }
        return indexValues;
    }
}

