/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.search.annotations.ExperimentalSearchSpi;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ExperimentalSearchSpi
abstract class AbstractNumberOperatorQueryFactory {
    private final DoubleConverter doubleConverter;

    protected AbstractNumberOperatorQueryFactory(DoubleConverter doubleConverter) {
        this.doubleConverter = Objects.requireNonNull(doubleConverter);
    }

    List<Double> getIndexValues(List<QueryLiteral> rawValues) {
        ArrayList values = Lists.newArrayListWithCapacity((int)rawValues.size());
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.isEmpty()) {
                values.add(null);
                continue;
            }
            Double indexValue = this.doubleConverter.getDouble(rawValue.asString());
            if (indexValue == null) continue;
            values.add(indexValue);
        }
        return values;
    }
}

