/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.jql;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.jql.AbstractOperatorQueryFactory;
import com.atlassian.jira.search.jql.OperatorSpecificQueryFactory;
import com.atlassian.jira.search.jql.TermQueryFactory;
import com.atlassian.jira.search.query.BooleanQuery;
import com.atlassian.jira.search.query.DefaultBooleanQuery;
import com.atlassian.jira.search.query.DefaultMatchNoDocsQuery;
import com.atlassian.jira.search.query.DefaultTermsSetQuery;
import com.atlassian.jira.search.query.TermsSetQuery;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public abstract class AbstractEqualityQueryFactory<T>
extends AbstractOperatorQueryFactory<T>
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractEqualityQueryFactory.class);

    protected AbstractEqualityQueryFactory(IndexInfoResolver<T> indexInfoResolver) {
        super(indexInfoResolver);
    }

    @Override
    public Query createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (Operator.EQUALS.equals((Object)operator)) {
            return this.handleEquals(fieldName, this.getIndexValues(rawValues));
        }
        if (Operator.NOT_EQUALS.equals((Object)operator)) {
            return this.handleNotEquals(fieldName, this.getIndexValues(rawValues));
        }
        log.debug("Create query for single value was called with operator '{}', this only handles '=' and '!='.", (Object)operator.getDisplayString());
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public Query createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (Operator.IN.equals((Object)operator)) {
            return this.handleEquals(fieldName, this.getIndexValues(rawValues));
        }
        if (Operator.NOT_IN.equals((Object)operator)) {
            return this.handleNotEquals(fieldName, this.getIndexValues(rawValues));
        }
        log.debug("Create query for multiple value was called with operator '{}', this only handles 'in' and 'not in'.", (Object)operator.getDisplayString());
        return DefaultMatchNoDocsQuery.INSTANCE;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    Query handleNotEquals(String fieldName, List<String> indexValues) {
        TermsSetQuery termInSetQuery = this.getTermInSetQuery(fieldName, indexValues);
        if (termInSetQuery.terms().isEmpty()) {
            return this.getIsNotEmptyQuery(fieldName);
        }
        DefaultBooleanQuery.Builder boolQuery = new DefaultBooleanQuery.Builder();
        boolQuery.add(this.getIsNotEmptyQuery(fieldName), BooleanQuery.Occur.FILTER);
        boolQuery.add(termInSetQuery, BooleanQuery.Occur.MUST_NOT);
        boolQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanQuery.Occur.FILTER);
        return boolQuery.build();
    }

    Query handleEquals(String fieldName, List<String> indexValues) {
        if (indexValues.size() == 1) {
            String id = indexValues.get(0);
            return id == null ? this.getIsEmptyQuery(fieldName) : this.getTermQuery(fieldName, id);
        }
        TermsSetQuery termInSetQuery = this.getTermInSetQuery(fieldName, indexValues);
        if (this.hasEmptyValues(indexValues)) {
            return new DefaultBooleanQuery.Builder().add(termInSetQuery, BooleanQuery.Occur.SHOULD).add(this.getIsEmptyQuery(fieldName), BooleanQuery.Occur.SHOULD).build();
        }
        return termInSetQuery;
    }

    private TermsSetQuery getTermInSetQuery(String fieldName, List<String> indexValues) {
        return indexValues.stream().filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), terms -> new DefaultTermsSetQuery(fieldName, (Collection<String>)terms)));
    }

    private boolean hasEmptyValues(List<String> indexValues) {
        return indexValues.stream().anyMatch(Objects::isNull);
    }

    abstract Query getIsEmptyQuery(String var1);

    abstract Query getIsNotEmptyQuery(String var1);
}

