/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.annotations.ExperimentalSearchSpi;
import com.atlassian.jira.search.field.AnalyzedTextField;
import com.atlassian.jira.search.field.DateTimeField;
import com.atlassian.jira.search.field.DoubleField;
import com.atlassian.jira.search.field.FieldValue;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.KeywordField;
import com.atlassian.jira.search.field.LongField;
import com.atlassian.jira.search.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@ExperimentalSearchSpi
public abstract class VisibilityBaseFieldIndexer
implements FieldIndexer {
    protected final FieldVisibilityManager fieldVisibilityManager;
    protected final Field visibleField;
    protected final Field invisibleField;

    protected VisibilityBaseFieldIndexer(FieldVisibilityManager fieldVisibilityManager, AnalyzedTextField visibleField) {
        this(fieldVisibilityManager, visibleField, UnsearchableFieldBuilder.analyzedText(visibleField));
    }

    protected VisibilityBaseFieldIndexer(FieldVisibilityManager fieldVisibilityManager, KeywordField visibleField) {
        this(fieldVisibilityManager, visibleField, UnsearchableFieldBuilder.keyword(visibleField));
    }

    protected VisibilityBaseFieldIndexer(FieldVisibilityManager fieldVisibilityManager, DoubleField visibleField) {
        this(fieldVisibilityManager, visibleField, UnsearchableFieldBuilder.doubleField(visibleField));
    }

    protected VisibilityBaseFieldIndexer(FieldVisibilityManager fieldVisibilityManager, LongField visibleField) {
        this(fieldVisibilityManager, visibleField, UnsearchableFieldBuilder.longField(visibleField));
    }

    protected VisibilityBaseFieldIndexer(FieldVisibilityManager fieldVisibilityManager, DateTimeField visibleField) {
        this(fieldVisibilityManager, visibleField, UnsearchableFieldBuilder.dateTimeField(visibleField));
    }

    protected VisibilityBaseFieldIndexer(FieldVisibilityManager fieldVisibilityManager, Field visibleField, Field invisibleField) {
        this.fieldVisibilityManager = Objects.requireNonNull(fieldVisibilityManager);
        this.visibleField = Objects.requireNonNull(visibleField);
        this.invisibleField = Objects.requireNonNull(invisibleField);
    }

    @Override
    public Collection<Field> getFields() {
        return List.of(this.visibleField, this.invisibleField);
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.fieldVisibilityManager.isFieldVisible(this.getId(), issue);
    }

    protected void indexField(FieldValueCollector collector, String value, Issue issue) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Field field = this.getField(this.isFieldVisibleAndInScope(issue));
            collector.add(field.name(), value);
        }
    }

    protected void indexField(FieldValueCollector collector, Double value, Issue issue) {
        Field field = this.getField(this.isFieldVisibleAndInScope(issue));
        collector.add(field.name(), value);
    }

    protected void indexField(FieldValueCollector collector, Long value, Issue issue) {
        Field field = this.getField(this.isFieldVisibleAndInScope(issue));
        collector.add(field.name(), value);
    }

    protected void indexField(FieldValueCollector collector, Date value, Issue issue) {
        Field field = this.getField(this.isFieldVisibleAndInScope(issue));
        collector.add(field.name(), value);
    }

    protected void indexFieldsForSorting(FieldValueCollector collector, String value, Field sortField, Issue issue) {
        this.indexField(collector, value, issue);
        String sortValue = FieldIndexerUtil.getValueForSorting(value);
        if (StringUtils.isNotBlank((CharSequence)sortValue) && this.isFieldVisibleAndInScope(issue)) {
            collector.add(new FieldValue(sortField.name(), sortValue));
        }
    }

    protected Field getField(boolean visible) {
        return visible ? this.visibleField : this.invisibleField;
    }

    public static interface UnsearchableFieldBuilder {
        public static final String NAME_SUFFIX = "_unsearchable";

        public static AnalyzedTextField analyzedText(AnalyzedTextField field) {
            AnalyzedTextField.Builder builder = AnalyzedTextField.builder(field.name() + NAME_SUFFIX);
            if (field.isConcatenated()) {
                builder.concatenated();
            }
            return UnsearchableFieldBuilder.buildField(field, builder);
        }

        public static KeywordField keyword(KeywordField field) {
            KeywordField.Builder builder = KeywordField.builder(field.name() + NAME_SUFFIX);
            return UnsearchableFieldBuilder.buildField(field, builder);
        }

        public static DoubleField doubleField(DoubleField field) {
            DoubleField.Builder builder = DoubleField.builder(field.name() + NAME_SUFFIX);
            return UnsearchableFieldBuilder.buildField(field, builder);
        }

        public static LongField longField(LongField field) {
            LongField.Builder builder = LongField.builder(field.name() + NAME_SUFFIX);
            return UnsearchableFieldBuilder.buildField(field, builder);
        }

        public static DateTimeField dateTimeField(DateTimeField field) {
            DateTimeField.Builder builder = DateTimeField.builder(field.name() + NAME_SUFFIX);
            return UnsearchableFieldBuilder.buildField(field, builder);
        }

        private static <T extends Field> T buildField(Field field, Field.Builder<T> builder) {
            if (field.isMultiValued()) {
                builder.multiValued();
            }
            return builder.stored().overrideLuceneName(field.name()).retrievalName(field.name()).build();
        }
    }
}

