/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.index;

import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.FieldValue;
import com.atlassian.jira.search.field.FieldValues;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

@ExperimentalSearchApi
public final class IndexRequest {
    private final String documentId;
    private final Long documentVersion;
    private final FieldValues values;

    private IndexRequest(Builder builder) {
        this.documentId = builder.documentId;
        this.documentVersion = builder.documentVersion;
        this.values = FieldValues.copyOf((Collection<FieldValue>)builder.values.build());
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public Optional<Long> getDocumentVersion() {
        return Optional.ofNullable(this.documentVersion);
    }

    public static Builder builder(String documentId) {
        return new Builder(documentId);
    }

    public static Builder builder(String documentId, long version) {
        return new Builder(documentId, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexRequest that = (IndexRequest)o;
        return Objects.equals(this.documentId, that.documentId) && Objects.equals(this.documentVersion, that.documentVersion);
    }

    public int hashCode() {
        return Objects.hash(this.documentId, this.documentVersion);
    }

    public FieldValues getValues() {
        return this.values;
    }

    public static class Builder {
        private final String documentId;
        private final ImmutableList.Builder<FieldValue> values = new ImmutableList.Builder();
        private Long documentVersion;

        public Builder(String documentId) {
            this.documentId = Objects.requireNonNull(documentId, "documentId");
        }

        public Builder(String documentId, long documentVersion) {
            this.documentId = Objects.requireNonNull(documentId, "documentId");
            this.documentVersion = documentVersion;
        }

        public Builder version(long documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public Builder values(FieldValue ... values) {
            this.values.add((Object[])values);
            return this;
        }

        public Builder values(Collection<FieldValue> values) {
            this.values.addAll(values);
            return this;
        }

        public IndexRequest build() {
            return new IndexRequest(this);
        }
    }
}

