/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.jira.search.Document;
import com.atlassian.jira.search.FieldVisitor;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.AbstractField;
import com.atlassian.jira.search.field.NumericField;
import java.util.List;

@ExperimentalSearchApi
public final class IntField
extends AbstractField<Integer>
implements NumericField {
    private IntField(Builder builder) {
        super(builder);
    }

    @Override
    public <T> T accept(FieldVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Class<Integer> getValueType() {
        return Integer.class;
    }

    @Override
    public List<Integer> get(Document document) {
        return document.getNumbers(this.name()).stream().map(Number::intValue).toList();
    }

    public static Builder builder(String fieldName) {
        return new Builder(fieldName);
    }

    public static final class Builder
    extends AbstractField.Builder<IntField> {
        private Builder(String fieldName) {
            super(fieldName);
        }

        @Override
        public IntField build() {
            return new IntField(this);
        }
    }
}

