/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.TypedField;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Internal
abstract class AbstractField<T>
implements TypedField<T> {
    private final String name;
    private final boolean isIndexed;
    private final boolean hasDocValues;
    private final boolean isStored;
    private final boolean isMultiValued;
    private final List<Field> subfields;
    private final List<String> retrievalNames;
    private final String lucenePhysicalName;
    private final Class<T> valueType = (Class)new TypeToken<T>(this.getClass()){}.getType();

    AbstractField(Builder<? extends AbstractField<T>> builder) {
        this.name = builder.fieldName;
        this.isIndexed = builder.isIndexed;
        this.hasDocValues = builder.hasDocValues;
        this.isStored = builder.isStored;
        this.isMultiValued = builder.isMultiValued;
        this.subfields = builder.subfields;
        this.retrievalNames = builder.retrievalNames;
        this.lucenePhysicalName = builder.luceneNameOverride;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isIndexed, this.hasDocValues, this.isStored, this.subfields, this.retrievalNames, this.lucenePhysicalName);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isIndexed() {
        return this.isIndexed;
    }

    @Override
    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    @Override
    public boolean isStored() {
        return this.isStored;
    }

    @Override
    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    @Override
    public List<Field> subfields() {
        return this.subfields;
    }

    @Override
    public List<String> getRetrievalNames() {
        return this.retrievalNames;
    }

    @Override
    public Optional<String> getLuceneNameOverride() {
        return Optional.ofNullable(this.lucenePhysicalName);
    }

    @Override
    public Class<T> getValueType() {
        return this.valueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractField that = (AbstractField)o;
        return new EqualsBuilder().append(this.isIndexed, that.isIndexed).append(this.hasDocValues, that.hasDocValues).append(this.isStored, that.isStored).append(this.isMultiValued, that.isMultiValued).append((Object)this.name, (Object)that.name).append(this.subfields, that.subfields).append(this.retrievalNames, that.retrievalNames).append((Object)this.lucenePhysicalName, (Object)that.lucenePhysicalName).isEquals();
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    protected ToStringBuilder toStringBuilder() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("isIndexed", this.isIndexed).append("hasDocValues", this.hasDocValues).append("isStored", this.isStored).append("isMultiValued", this.isMultiValued).append("subfields", this.subfields).append("retrievalNames", this.retrievalNames).append("lucenePhysicalName", (Object)this.lucenePhysicalName);
    }

    public static abstract class Builder<T extends AbstractField<?>>
    implements Field.Builder<T> {
        final String fieldName;
        final List<Field> subfields;
        final List<String> retrievalNames;
        boolean isIndexed;
        boolean isStored;
        boolean hasDocValues;
        boolean isMultiValued;
        private String luceneNameOverride;

        Builder(String fieldName) {
            Assertions.notBlank("fieldName", fieldName);
            this.fieldName = fieldName;
            this.subfields = new ArrayList<Field>();
            this.retrievalNames = new ArrayList<String>();
        }

        @Override
        public Builder<T> indexed() {
            this.isIndexed = true;
            return this;
        }

        @Override
        public Builder<T> stored() {
            this.isStored = true;
            return this;
        }

        @Override
        public Builder<T> docValues() {
            this.hasDocValues = true;
            return this;
        }

        @Override
        public Builder<T> multiValued() {
            this.isMultiValued = true;
            return this;
        }

        @Override
        public Builder<T> subfield(Field subfield) {
            this.subfields.add(subfield);
            return this;
        }

        @Override
        public Builder<T> retrievalName(String retrievalName) {
            this.retrievalNames.add(retrievalName);
            return this;
        }

        @Override
        public Field.Builder<T> overrideLuceneName(String luceneNameOverride) {
            this.luceneNameOverride = luceneNameOverride;
            return this;
        }
    }
}

