/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.aggregation.bucket.terms;

import com.atlassian.jira.search.aggregation.Aggregation;
import com.atlassian.jira.search.aggregation.AggregationsRequest;
import com.atlassian.jira.search.aggregation.bucket.BucketAggregation;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Map;
import java.util.Objects;

@ExperimentalSearchApi
public final class TermsAggregation
implements BucketAggregation {
    private final String field;
    private final AggregationsRequest subAggregations;
    private final int size;

    private TermsAggregation(String field, AggregationsRequest subAggregations, int size) {
        this.field = Assertions.notBlank("field", field);
        this.subAggregations = subAggregations;
        this.size = size;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public AggregationsRequest getSubAggregations() {
        return this.subAggregations;
    }

    public int getSize() {
        return this.size;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermsAggregation that = (TermsAggregation)o;
        return this.size == that.getSize() && Objects.equals(this.field, that.field) && Objects.equals(this.subAggregations, that.subAggregations);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.field, this.subAggregations);
    }

    public static final class Builder {
        private String field;
        private final AggregationsRequest.Builder subAggregations = AggregationsRequest.builder();
        private int size = 10000;

        private Builder() {
        }

        public Builder withField(String field) {
            this.field = field;
            return this;
        }

        public Builder withSubAggregation(String name, Aggregation aggregation) {
            this.subAggregations.put(name, aggregation);
            return this;
        }

        public Builder withSubAggregations(Map<String, Aggregation> aggregations) {
            this.subAggregations.putAll(aggregations);
            return this;
        }

        public Builder withSize(int size) {
            this.size = size;
            return this;
        }

        public TermsAggregation build() {
            return new TermsAggregation(this.field, this.subAggregations.build(), this.size);
        }
    }
}

