/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.aggregation;

import com.atlassian.jira.search.aggregation.Aggregation;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ExperimentalSearchApi
public final class AggregationsRequest
extends AbstractMap<String, Aggregation> {
    private final ImmutableSet<Map.Entry<String, Aggregation>> entries;

    private AggregationsRequest(Map<String, Aggregation> entries) {
        this.entries = ImmutableSet.copyOf(entries.entrySet());
    }

    @Override
    public Set<Map.Entry<String, Aggregation>> entrySet() {
        return this.entries;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AggregationsRequest that = (AggregationsRequest)o;
        return Objects.equals(this.entries, that.entries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entries);
    }

    public static class Builder {
        private final Map<String, Aggregation> aggregations = new HashMap<String, Aggregation>();

        public Builder put(String name, Aggregation aggregation) {
            this.aggregations.put(name, aggregation);
            return this;
        }

        public Builder putAll(Map<String, Aggregation> aggregations) {
            this.aggregations.putAll(aggregations);
            return this;
        }

        public AggregationsRequest build() {
            return new AggregationsRequest(this.aggregations);
        }
    }
}

