/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search;

import com.atlassian.jira.search.FieldVisitor;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@ExperimentalSearchApi
public interface Field {
    public String name();

    public <T> T accept(FieldVisitor<T> var1);

    default public boolean isIndexed() {
        return false;
    }

    default public boolean hasDocValues() {
        return false;
    }

    default public boolean isMultiValued() {
        return false;
    }

    default public boolean isStored() {
        return false;
    }

    default public List<Field> subfields() {
        return Collections.emptyList();
    }

    default public List<String> getRetrievalNames() {
        return Collections.emptyList();
    }

    default public Optional<String> getLuceneNameOverride() {
        return Optional.empty();
    }

    public static interface Builder<T extends Field> {
        public Builder<T> indexed();

        public Builder<T> docValues();

        public Builder<T> stored();

        public Builder<T> multiValued();

        public Builder<T> subfield(Field var1);

        default public Builder<T> subfield(Builder<?> fieldBuilder) {
            return this.subfield((Field)fieldBuilder.build());
        }

        public Builder<T> retrievalName(String var1);

        @Deprecated(forRemoval=true)
        public Builder<T> overrideLuceneName(String var1);

        public T build();
    }
}

