/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class PermissionGrantInput {
    private final PermissionHolder holder;
    private final ProjectPermissionKey permission;

    private PermissionGrantInput(PermissionHolder holder, ProjectPermissionKey permission) {
        this.holder = (PermissionHolder)Preconditions.checkNotNull((Object)holder);
        this.permission = (ProjectPermissionKey)Preconditions.checkNotNull((Object)permission);
    }

    public PermissionHolder getHolder() {
        return this.holder;
    }

    public ProjectPermissionKey getPermission() {
        return this.permission;
    }

    public static PermissionGrantInput newGrant(@Nonnull PermissionHolder holder, @Nonnull ProjectPermissionKey permissionKey) {
        return new PermissionGrantInput(holder, permissionKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("holder", (Object)this.holder).add("permission", (Object)this.permission).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionGrantInput that = (PermissionGrantInput)o;
        return Objects.equal((Object)this.holder, (Object)that.holder) && Objects.equal((Object)this.permission, (Object)that.permission);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.holder, this.permission});
    }
}

