/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizValueWrapper;
import java.sql.Timestamp;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractOfBizValueWrapper
implements OfBizValueWrapper {
    private static final Logger log = LoggerFactory.getLogger(AbstractOfBizValueWrapper.class);
    protected final GenericValue genericValue;
    private boolean debug = false;

    protected AbstractOfBizValueWrapper(GenericValue genericValue) {
        if (genericValue == null) {
            throw new IllegalArgumentException("GenericValue cannot be null.");
        }
        this.genericValue = genericValue;
    }

    @Override
    public String getString(String name) {
        if (this.debug) {
            Thread.dumpStack();
        }
        return this.genericValue.getString(name);
    }

    @Override
    public Timestamp getTimestamp(String name) {
        if (this.debug) {
            Thread.dumpStack();
        }
        return this.genericValue.getTimestamp(name);
    }

    @Override
    public Long getLong(String name) {
        if (this.debug) {
            Thread.dumpStack();
        }
        return this.genericValue.getLong(name);
    }

    @Override
    public GenericValue getGenericValue() {
        if (this.debug) {
            Thread.dumpStack();
        }
        return this.genericValue;
    }

    @Override
    public void store() {
        try {
            this.genericValue.store();
        }
        catch (GenericEntityException e) {
            log.error("Exception whilst trying to store genericValue " + String.valueOf(this.genericValue) + ".", (Throwable)e);
            throw new DataAccessException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractOfBizValueWrapper)) {
            return false;
        }
        AbstractOfBizValueWrapper abstractOfBizValueWrapper = (AbstractOfBizValueWrapper)o;
        return !(this.genericValue != null ? !this.genericValue.equals((Object)abstractOfBizValueWrapper.genericValue) : abstractOfBizValueWrapper.genericValue != null);
    }

    public int hashCode() {
        return this.genericValue != null ? this.genericValue.hashCode() : 0;
    }
}

