/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.AbstractOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.TermQueryFactory;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.search.annotations.DeprecatedBySearchApi;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="10.4", forRemoval=true)
@DeprecatedBySearchApi
@PublicApi
public class VersionLikeQueryFactory
extends AbstractOperatorQueryFactory<Version>
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(VersionLikeQueryFactory.class);

    VersionLikeQueryFactory(IndexInfoResolver indexInfoResolver) {
        super(indexInfoResolver);
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (rawValues == null) {
            return QueryFactoryResult.createFalseResult();
        }
        if (Operator.LIKE.equals((Object)operator)) {
            return this.handleLike(fieldName, this.getIndexValues(rawValues));
        }
        if (Operator.NOT_LIKE.equals((Object)operator)) {
            return this.handleNotLike(fieldName, this.getIndexValues(rawValues));
        }
        log.debug("Create query for single value was called with operator '{}', this only handles '~' and '!~'.", (Object)operator.getDisplayString());
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult handleNotLike(String fieldName, List<String> indexValues) {
        ArrayList notQueries = Lists.newArrayListWithCapacity((int)indexValues.size());
        for (String indexValue : indexValues) {
            notQueries.add(this.getTermQuery(fieldName, indexValue));
        }
        if (notQueries.isEmpty()) {
            return new QueryFactoryResult(TermQueryFactory.nonEmptyQuery(fieldName));
        }
        BooleanQuery.Builder boolQuery = new BooleanQuery.Builder();
        for (Query query : notQueries) {
            boolQuery.add(query, BooleanClause.Occur.MUST_NOT);
        }
        boolQuery.add(TermQueryFactory.nonEmptyQuery(fieldName), BooleanClause.Occur.FILTER);
        boolQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanClause.Occur.FILTER);
        return new QueryFactoryResult((Query)boolQuery.build(), false);
    }

    private QueryFactoryResult handleLike(String fieldName, List<String> indexValues) {
        BooleanQuery.Builder orQuery = new BooleanQuery.Builder();
        for (String id : indexValues) {
            orQuery.add((Query)this.getTermQuery(fieldName, id), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)orQuery.build());
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.LIKE) {
            QueryFactoryResult result = new QueryFactoryResult(TermQueryFactory.nonEmptyQuery(fieldName), true);
            return QueryFactoryResult.wrapWithVisibilityQuery(fieldName, result);
        }
        if (operator == Operator.NOT_LIKE) {
            return new QueryFactoryResult(TermQueryFactory.nonEmptyQuery(fieldName));
        }
        log.debug("Create query for empty operand was called with operator '{}', this only handles '~' and '~!' ", (Object)operator.getDisplayString());
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        log.debug("LIKE clauses do not support multi value operands.");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return Operator.LIKE.equals((Object)operator) || Operator.NOT_LIKE.equals((Object)operator);
    }
}

