/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.information;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.search.annotations.DeprecatedBySearchApi;
import com.atlassian.jira.search.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class GenericSearcherInformation<T extends SearchableField>
implements SearcherInformation<T> {
    private final String id;
    private final String nameKey;
    private final AtomicReference<T> fieldReference;
    private final SearcherGroupType searcherGroupType;
    private final Supplier<List<FieldIndexer>> searchApiFieldIndexerSupplier;
    private final Supplier<List<com.atlassian.jira.issue.index.indexers.FieldIndexer>> relatedFieldIndexeSupplier;

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public GenericSearcherInformation(String id, String nameKey, List<Class<? extends com.atlassian.jira.issue.index.indexers.FieldIndexer>> relatedIndexers, AtomicReference<T> fieldReference, SearcherGroupType searcherGroupType) {
        this.id = Assertions.notBlank("id", id);
        this.nameKey = Assertions.notBlank("nameKey", nameKey);
        this.fieldReference = Assertions.notNull("fieldReference", fieldReference);
        this.searcherGroupType = Assertions.notNull("searcherGroupType", searcherGroupType);
        Assertions.notNull("relatedIndexers", relatedIndexers);
        this.searchApiFieldIndexerSupplier = Suppliers.memoize(Collections::emptyList);
        this.relatedFieldIndexeSupplier = this.relatedFieldIndexerSupplier(relatedIndexers);
    }

    protected GenericSearcherInformation(Builder<T> builder) {
        Assertions.notNull("builder", builder);
        this.id = Assertions.notBlank("builder.id", builder.id);
        this.nameKey = Assertions.notBlank("builder.nameKey", builder.nameKey);
        this.fieldReference = Assertions.notNull("builder.fieldReference", builder.fieldReference);
        this.searcherGroupType = Assertions.notNull("builder.searcherGroupType", builder.searcherGroupType);
        this.searchApiFieldIndexerSupplier = this.searchApiFieldIndexerSupplier(builder);
        this.relatedFieldIndexeSupplier = this.relatedFieldIndexerSupplier(builder.relatedIndexers);
    }

    private Supplier<List<FieldIndexer>> searchApiFieldIndexerSupplier(Builder<T> builder) {
        return Suppliers.memoize(() -> builder.indexers.stream().map(this::loadIndexer).toList());
    }

    private Supplier<List<com.atlassian.jira.issue.index.indexers.FieldIndexer>> relatedFieldIndexerSupplier(List<Class<? extends com.atlassian.jira.issue.index.indexers.FieldIndexer>> relatedIndexers) {
        return Suppliers.memoize(() -> relatedIndexers.stream().map(this::loadRelatedIndexer).toList());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getNameKey() {
        return this.nameKey;
    }

    @Override
    public List<FieldIndexer> getIndexers() {
        return (List)this.searchApiFieldIndexerSupplier.get();
    }

    @Override
    public List<com.atlassian.jira.issue.index.indexers.FieldIndexer> getRelatedIndexers() {
        return (List)this.relatedFieldIndexeSupplier.get();
    }

    @Override
    public SearcherGroupType getSearcherGroupType() {
        return this.searcherGroupType;
    }

    @Override
    public T getField() {
        return (T)((SearchableField)this.fieldReference.get());
    }

    FieldIndexer loadIndexer(Class<? extends FieldIndexer> clazz) {
        try {
            return (FieldIndexer)ComponentAccessor.getComponent(ComponentClassManager.class).newInstance(clazz.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load indexer '" + clazz.getName() + "'", e);
        }
    }

    @Deprecated
    com.atlassian.jira.issue.index.indexers.FieldIndexer loadRelatedIndexer(Class<? extends com.atlassian.jira.issue.index.indexers.FieldIndexer> clazz) {
        try {
            return (com.atlassian.jira.issue.index.indexers.FieldIndexer)ComponentAccessor.getComponent(ComponentClassManager.class).newInstance(clazz.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load indexer '" + clazz.getName() + "'", e);
        }
    }

    public static <T extends SearchableField> Builder<T> builder(String id) {
        return new Builder(id);
    }

    public static class Builder<T extends SearchableField> {
        private final String id;
        private String nameKey;
        private final List<Class<? extends com.atlassian.jira.issue.index.indexers.FieldIndexer>> relatedIndexers = new ArrayList<Class<? extends com.atlassian.jira.issue.index.indexers.FieldIndexer>>();
        private final List<Class<? extends FieldIndexer>> indexers = new ArrayList<Class<? extends FieldIndexer>>();
        private AtomicReference<T> fieldReference;
        private SearcherGroupType searcherGroupType;

        public Builder(String id) {
            this.id = id;
        }

        public Builder<T> nameKey(String nameKey) {
            this.nameKey = nameKey;
            return this;
        }

        @SafeVarargs
        public final Builder<T> relatedIndexers(Class<? extends com.atlassian.jira.issue.index.indexers.FieldIndexer> ... indexers) {
            Collections.addAll(this.relatedIndexers, indexers);
            return this;
        }

        @SafeVarargs
        public final Builder<T> indexers(Class<? extends FieldIndexer> ... fieldIndexers) {
            Collections.addAll(this.indexers, fieldIndexers);
            return this;
        }

        public Builder<T> fieldReference(AtomicReference<T> fieldReference) {
            this.fieldReference = fieldReference;
            return this;
        }

        public Builder<T> searcherGroupType(SearcherGroupType searcherGroupType) {
            this.searcherGroupType = searcherGroupType;
            return this;
        }

        public GenericSearcherInformation<T> build() {
            return new GenericSearcherInformation(this);
        }
    }
}

