/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.lucenelegacy.NumericUtils;
import com.atlassian.jira.search.annotations.DeprecatedBySearchApi;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

@Deprecated(since="10.4", forRemoval=true)
@DeprecatedBySearchApi
public class NumberCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final DoubleConverter doubleConverter;
    private final boolean skipIndexingNull;

    public NumberCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, DoubleConverter doubleConverter, boolean skipIndexingNull) {
        super(fieldVisibilityManager, Assertions.notNull("customField", customField));
        this.doubleConverter = Assertions.notNull("doubleConverter", doubleConverter);
        this.skipIndexingNull = skipIndexingNull;
    }

    public NumberCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, DoubleConverter doubleConverter) {
        this(fieldVisibilityManager, customField, doubleConverter, false);
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    @Override
    public Boolean skipsIndexingNull() {
        return this.skipIndexingNull;
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        if (value != null) {
            String string = this.doubleConverter.getStringForLucene((Double)value);
            if (searchable) {
                doc.add((IndexableField)new StringField(this.getDocumentFieldId(), string, Field.Store.YES));
                doc.add((IndexableField)new DoubleDocValuesField(this.getDocumentFieldId(), ((Double)value).doubleValue()));
            } else {
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), string));
            }
            if (searchable) {
                String encoded = NumericUtils.doubleToPrefixCoded((double)((Double)value));
                doc.add((IndexableField)new StringField("sort_" + this.getDocumentFieldId(), encoded, Field.Store.NO));
                doc.add((IndexableField)new SortedDocValuesField("sort_" + this.getDocumentFieldId(), new BytesRef((CharSequence)encoded)));
            }
        } else if (searchable && !this.skipIndexingNull) {
            String encoded = NumericUtils.doubleToPrefixCoded((double)Double.MAX_VALUE);
            doc.add((IndexableField)new StringField("sort_" + this.getDocumentFieldId(), encoded, Field.Store.NO));
            doc.add((IndexableField)new SortedDocValuesField("sort_" + this.getDocumentFieldId(), new BytesRef((CharSequence)encoded)));
        }
    }
}

