/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.annotations.DeprecatedBySearchApi;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

@Internal
public class FieldIndexerUtil {
    public static final String EMPTY_SORT_STRING_VALUE = String.valueOf('\ufffd');
    public static final int MAX_SORT_LENGTH = 50;

    private FieldIndexerUtil() {
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public static void indexKeywordWithDefault(Document doc, String indexField, String fieldValue, String defaultValue) {
        FieldIndexerUtil.indexKeywordWithDefault(doc, indexField, fieldValue, defaultValue, true);
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public static void indexKeywordWithDefault(Document doc, String indexField, Long aLong, String defaultValue) {
        String value = aLong != null ? aLong.toString() : null;
        FieldIndexerUtil.indexKeywordWithDefault(doc, indexField, value, defaultValue);
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public static void indexKeywordWithDefault(Document doc, String indexField, String fieldValue, String defaultValue, boolean searchable) {
        String value = FieldIndexerUtil.getOrDefault(fieldValue, defaultValue);
        if (searchable) {
            doc.add((IndexableField)new StringField(indexField, value, Field.Store.YES));
            doc.add((IndexableField)new SortedDocValuesField(indexField, new BytesRef((CharSequence)value)));
        } else {
            doc.add((IndexableField)new StoredField(indexField, value));
        }
    }

    public static String getOrDefault(String fieldValue, String defaultValue) {
        return StringUtils.isNotBlank((CharSequence)fieldValue) ? fieldValue : defaultValue;
    }

    public static String getValueForSorting(String fieldValue) {
        String trimmed;
        String string = trimmed = fieldValue == null ? null : fieldValue.trim();
        if (!StringUtils.isBlank((CharSequence)trimmed)) {
            if (trimmed.length() > 50) {
                return trimmed.substring(0, 50);
            }
            return trimmed;
        }
        return EMPTY_SORT_STRING_VALUE;
    }
}

