/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.search.annotations.DeprecatedBySearchApi;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

@Deprecated(since="10.4", forRemoval=true)
@DeprecatedBySearchApi
public class ExactTextCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final boolean skipIndexingNull;

    public ExactTextCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, boolean skipIndexingNull) {
        super(fieldVisibilityManager, Assertions.notNull("field", customField));
        this.skipIndexingNull = skipIndexingNull;
    }

    public ExactTextCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        this(fieldVisibilityManager, customField, false);
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    @Override
    public Boolean skipsIndexingNull() {
        return this.skipIndexingNull;
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        String stringValue = this.customField.getCustomFieldType().getStringFromSingularObject(value);
        if (value != null) {
            if (searchable) {
                doc.add((IndexableField)new StringField(this.getDocumentFieldId(), stringValue, Field.Store.YES));
                doc.add((IndexableField)new SortedDocValuesField(this.getDocumentFieldId(), new BytesRef((CharSequence)stringValue)));
            } else {
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), stringValue));
            }
        }
        if (!this.skipIndexingNull) {
            String string = FieldIndexerUtil.getValueForSorting((String)value);
            doc.add((IndexableField)new SortedDocValuesField("sort_" + this.getDocumentFieldId(), new BytesRef((CharSequence)string)));
        }
    }
}

