/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusCategoryJsonBean;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.util.JiraUrlCodec;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StatusJsonBean {
    @JsonProperty
    @Schema(example="http://localhost:8090/jira/rest/api/2.0/status/10000")
    private String self;
    @JsonProperty
    @Schema(example="green")
    private String statusColor;
    @JsonProperty
    @Schema(example="The issue is currently being worked on.")
    private String description;
    @JsonProperty
    @Schema(example="http://localhost:8090/jira/images/icons/progress.gif")
    private String iconUrl;
    @JsonProperty
    @Schema(example="In Progress")
    private String name;
    @JsonProperty
    @Schema(example="10000")
    private String id;
    @JsonProperty
    private StatusCategoryJsonBean statusCategory;

    public StatusJsonBean() {
    }

    public StatusJsonBean(String self, String statusColor, String description, String iconUrl, String name, String id) {
        this.self = self;
        this.statusColor = statusColor;
        this.description = description;
        this.iconUrl = iconUrl;
        this.name = name;
        this.id = id;
    }

    public String self() {
        return this.self;
    }

    public StatusJsonBean self(String self) {
        return new StatusJsonBean(self, this.statusColor, this.description, this.iconUrl, this.name, this.id);
    }

    public String statusColor() {
        return this.statusColor;
    }

    public StatusJsonBean statusColor(String statusColor) {
        return new StatusJsonBean(this.self, statusColor, this.description, this.iconUrl, this.name, this.id);
    }

    public String description() {
        return this.description;
    }

    public StatusJsonBean description(String description) {
        return new StatusJsonBean(this.self, this.statusColor, description, this.iconUrl, this.name, this.id);
    }

    public String iconUrl() {
        return this.iconUrl;
    }

    public StatusJsonBean iconUrl(String iconUrl) {
        return new StatusJsonBean(this.self, this.statusColor, this.description, iconUrl, this.name, this.id);
    }

    public String name() {
        return this.name;
    }

    public StatusJsonBean name(String name) {
        return new StatusJsonBean(this.self, this.statusColor, this.description, this.iconUrl, name, this.id);
    }

    public String id() {
        return this.id;
    }

    public StatusJsonBean id(String id) {
        return new StatusJsonBean(this.self, this.statusColor, this.description, this.iconUrl, this.name, id);
    }

    public StatusCategoryJsonBean statusCategory() {
        return this.statusCategory;
    }

    public static StatusJsonBean bean(Status status, JiraBaseUrls urls) {
        Object absoluteIconUrl;
        if (status == null) {
            return null;
        }
        StatusCategoryJsonBean statusCategoryJsonBean = StatusCategoryJsonBean.bean(status.getStatusCategory(), urls);
        try {
            absoluteIconUrl = new URL(status.getIconUrl()).toString();
        }
        catch (MalformedURLException e) {
            absoluteIconUrl = urls.baseUrl() + status.getIconUrl();
        }
        return new Builder().self(urls.restApi2BaseUrl() + "status/" + JiraUrlCodec.encode(status.getId())).name(status.getNameTranslation()).id(status.getId()).iconUrl((String)absoluteIconUrl).description(status.getDescTranslation()).statusCategory(statusCategoryJsonBean).build();
    }

    public static Collection<StatusJsonBean> beans(Collection<Status> allowedValues, JiraBaseUrls baseUrls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)allowedValues.size());
        for (Status from : allowedValues) {
            result.add(StatusJsonBean.bean(from, baseUrls));
        }
        return result;
    }

    public static StatusJsonBean bean(String id, String name, String self, String iconUrl, String description) {
        return new Builder().self(self).description(description).iconUrl(iconUrl).name(name).id(id).build();
    }

    public static StatusJsonBean bean(String id, String name, String self, String iconUrl, String description, StatusCategoryJsonBean statusCategoryJsonBean) {
        return new Builder().self(self).description(description).iconUrl(iconUrl).name(name).id(id).statusCategory(statusCategoryJsonBean).build();
    }

    public static class Builder {
        private String self;
        private String description;
        private String iconUrl;
        private String name;
        private String id;
        private StatusCategoryJsonBean statusCategory;

        public Builder self(String self) {
            this.self = self;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder statusCategory(StatusCategoryJsonBean statusCategory) {
            this.statusCategory = statusCategory;
            return this;
        }

        public StatusJsonBean build() {
            StatusJsonBean statusJsonBean = new StatusJsonBean().self(this.self).description(this.description).iconUrl(this.iconUrl).name(this.name).id(this.id);
            statusJsonBean.statusCategory = this.statusCategory;
            return statusJsonBean;
        }
    }
}

