/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.util.TextTermEscaper;
import com.atlassian.jira.search.annotations.DeprecatedBySearchApi;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.lucene.parsing.LuceneQueryParserFactory;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class TextQueryValidator {
    private static final Logger log = LoggerFactory.getLogger(TextQueryValidator.class);
    public static final Pattern BAD_RANGEIN_PATTERN = Pattern.compile("Cannot parse.*Was expecting.*(\"TO\"|<RANGEIN_QUOTED>|<RANGEIN_GOOP>|\"]\"|\"}\").*", 32);
    public static final Pattern BAD_RANGEEX_PATTERN = Pattern.compile("Cannot parse.*Was expecting.*(\"TO\"|<RANGEEX_QUOTED>|<RANGEEX_GOOP>|\"]\"|\"}\").*", 32);

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public MessageSet validate(QueryParser queryParser, String query, String fieldName, @Nullable String sourceFunction, boolean shortMessage, I18nHelper i18n) {
        MessageSetImpl messageSet = new MessageSetImpl();
        try {
            queryParser.parse(TextTermEscaper.escape(query));
        }
        catch (ParseException e) {
            this.handleException(fieldName, sourceFunction, query, i18n, messageSet, shortMessage, (Exception)((Object)e));
        }
        catch (RuntimeException re) {
            this.handleException(fieldName, sourceFunction, query, i18n, messageSet, shortMessage, re);
        }
        return messageSet;
    }

    public MessageSet validate(String fieldId, String query, String fieldName, @Nullable String sourceFunction, boolean shortMessage, I18nHelper i18n) {
        MessageSetImpl messageSet = new MessageSetImpl();
        try {
            this.queryParserFor(fieldId).parse(TextTermEscaper.escape(query));
        }
        catch (ParseException e) {
            this.handleException(fieldName, sourceFunction, query, i18n, messageSet, shortMessage, (Exception)((Object)e));
        }
        catch (RuntimeException re) {
            this.handleException(fieldName, sourceFunction, query, i18n, messageSet, shortMessage, re);
        }
        return messageSet;
    }

    private QueryParser queryParserFor(String fieldId) {
        return ComponentAccessor.getComponent(LuceneQueryParserFactory.class).createParserFor(fieldId);
    }

    private void handleException(String fieldName, @Nullable String sourceFunction, String value, I18nHelper i18n, MessageSet messageSet, boolean useShortMessage, Exception ex) {
        String errorMessage = this.translateException(ex, i18n, fieldName, sourceFunction, useShortMessage, value);
        if (errorMessage != null) {
            messageSet.addErrorMessage(errorMessage);
        } else {
            log.debug(String.format("Unable to parse the text '%s' for field '%s'.", value, fieldName), (Throwable)ex);
            if (sourceFunction != null) {
                messageSet.addErrorMessage(useShortMessage ? i18n.getText("navigator.error.parse.function", sourceFunction) : i18n.getText("jira.jql.text.clause.does.not.parse.function", fieldName, sourceFunction));
            } else {
                messageSet.addErrorMessage(useShortMessage ? i18n.getText("navigator.error.parse") : i18n.getText("jira.jql.text.clause.does.not.parse", value, fieldName));
            }
        }
    }

    @Nullable
    private String translateException(Exception ex, I18nHelper i18n, String fieldName, @Nullable String sourceFunction, boolean shortMessage, String value) {
        ParseException parseException;
        String exMessage;
        if (ex instanceof ParseException && (exMessage = (parseException = (ParseException)((Object)ex)).getMessage()) != null) {
            if (exMessage.endsWith("'*' or '?' not allowed as first character in WildcardQuery")) {
                return this.getErrorMessage(i18n, sourceFunction, shortMessage, fieldName, value, "jira.jql.text.clause.bad.start.in.wildcard");
            }
            if (BAD_RANGEIN_PATTERN.matcher(exMessage).matches() || BAD_RANGEEX_PATTERN.matcher(exMessage).matches()) {
                return this.getErrorMessage(i18n, sourceFunction, shortMessage, fieldName, value, "jira.jql.text.clause.incorrect.range.query");
            }
        }
        return null;
    }

    private String getErrorMessage(I18nHelper i18n, @Nullable String sourceFunction, boolean shortMessage, String fieldName, String value, String i18nMessagePrefix) {
        if (sourceFunction != null) {
            return shortMessage ? i18n.getText(i18nMessagePrefix + ".function.short", sourceFunction) : i18n.getText(i18nMessagePrefix + ".function", sourceFunction, fieldName);
        }
        return shortMessage ? i18n.getText(i18nMessagePrefix + ".short") : i18n.getText(i18nMessagePrefix, value, fieldName);
    }
}

