/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@PublicApi
public class ChangeHistoryGroup
implements Comparable<ChangeHistoryGroup>,
WithId {
    private final Long id;
    private final String userKey;
    private final Long projectId;
    private final Long issueId;
    private final String issueKey;
    private final List<ChangeHistoryItem> changeItems;
    private final Timestamp created;

    public ChangeHistoryGroup(Long id, Long projectId, Long issueId, String issueKey, String userKey, List<ChangeHistoryItem> changeItems, Timestamp created) {
        this.id = id;
        this.userKey = userKey;
        this.projectId = projectId;
        this.issueId = issueId;
        this.issueKey = issueKey;
        this.changeItems = changeItems;
        this.created = created;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getUser() {
        return this.userKey;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public List<ChangeHistoryItem> getChangeItems() {
        return this.changeItems;
    }

    @Override
    public int compareTo(ChangeHistoryGroup other) {
        if (this.created.compareTo(other.getCreated()) == 0) {
            return this.id.compareTo(other.getId());
        }
        return this.created.compareTo(other.getCreated());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ChangeHistoryGroup)) {
            return false;
        }
        ChangeHistoryGroup rhs = (ChangeHistoryGroup)o;
        return new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).append(this.getChangeItems(), rhs.getChangeItems()).append((Object)this.getUserKey(), (Object)rhs.getUserKey()).append((Object)this.getProjectId(), (Object)rhs.getProjectId()).append((Object)this.getIssueId(), (Object)rhs.getIssueId()).append((Object)this.getIssueKey(), (Object)rhs.getIssueKey()).append((Object)this.getCreated(), (Object)rhs.getCreated()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).append(this.getChangeItems()).append((Object)this.getUserKey()).append((Object)this.getProjectId()).append((Object)this.getIssueId()).append((Object)this.getIssueKey()).append((Object)this.getCreated()).toHashCode();
    }

    public String toString() {
        return "ChangeHistoryGroup{id=" + this.id + ", userKey='" + this.userKey + "', projectId=" + this.projectId + ", issueId=" + this.issueId + ", issueKey='" + this.issueKey + "', changeItems=" + String.valueOf(this.changeItems) + ", created=" + String.valueOf(this.created) + "}";
    }

    public static class Builder {
        private long id;
        private long projectId;
        private long issueId;
        private String issueKey;
        private String userKey;
        private Timestamp created;
        private List<ChangeHistoryItem> changeItems = Lists.newArrayList();

        public Builder withId(long id) {
            Assertions.notNull(id);
            this.id = id;
            return this;
        }

        public Builder inProject(long projectId) {
            Assertions.notNull(projectId);
            this.projectId = projectId;
            return this;
        }

        public Builder forIssue(long issueId, String issueKey) {
            Assertions.notNull(issueId);
            Assertions.notNull(issueKey);
            this.issueId = issueId;
            this.issueKey = issueKey;
            return this;
        }

        public Builder on(Timestamp on) {
            Assertions.notNull(on);
            this.created = on;
            return this;
        }

        public Builder byUser(String userKey) {
            this.userKey = userKey;
            return this;
        }

        public Builder withChanges(List<ChangeHistoryItem> items) {
            Assertions.notNull(items);
            this.changeItems = Lists.newArrayList(items);
            return this;
        }

        public Builder addChangeItem(ChangeHistoryItem item) {
            Assertions.notNull(item);
            this.changeItems.add(item);
            if (this.issueId == 0L) {
                this.id = item.getChangeGroupId();
                this.issueId = item.getIssueId();
                this.issueKey = item.getIssueKey();
                this.projectId = item.getProjectId();
                this.userKey = item.getUserKey();
                this.created = item.getCreated();
            }
            return this;
        }

        public ChangeHistoryGroup build() {
            return new ChangeHistoryGroup(this.id, this.projectId, this.issueId, this.issueKey, this.userKey, this.changeItems, this.created);
        }
    }
}

