/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ExperimentalApi
public final class UserDetails {
    private final String username;
    private final String password;
    private final String displayName;
    private final String emailAddress;
    private final Optional<Long> directoryId;

    private UserDetails(String username, String displayName, String password, String emailAddress, @Nullable Long directoryId) {
        this.username = Assertions.notNull("username", username);
        this.displayName = Assertions.notNull("displayName", displayName);
        this.password = password;
        this.emailAddress = emailAddress;
        this.directoryId = directoryId == null ? Optional.empty() : Optional.of(directoryId);
    }

    public UserDetails(String username, String displayName) {
        this(username, displayName, null, null, null);
    }

    public UserDetails withPassword(String password) {
        return new UserDetails(this.username, this.displayName, password, this.emailAddress, this.directoryId.orElse(null));
    }

    public UserDetails withEmail(String email) {
        return new UserDetails(this.username, this.displayName, this.password, email, this.directoryId.orElse(null));
    }

    public UserDetails withDirectory(Long directoryId) {
        return new UserDetails(this.username, this.displayName, this.password, this.emailAddress, directoryId);
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Optional<Long> getDirectoryId() {
        return this.directoryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserDetails)) {
            return false;
        }
        UserDetails that = (UserDetails)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.emailAddress, that.emailAddress) && Objects.equals(this.directoryId, that.directoryId);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password, this.displayName, this.emailAddress, this.directoryId);
    }

    public String toString() {
        return "UserDetails{username='" + this.username + "', password='" + this.password + "', displayName='" + this.displayName + "', emailAddress='" + this.emailAddress + "', directoryId=" + String.valueOf(this.directoryId) + "}";
    }
}

