/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.response;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.request.PageRequest;
import java.util.Objects;
import java.util.Optional;

@Internal
public class SearchResponse<T> {
    private final T data;
    private final PageRequest pageRequest;
    private final long totalHits;

    public SearchResponse(long totalHits, T data, PageRequest pageRequest) {
        this.data = data;
        this.totalHits = totalHits;
        this.pageRequest = Objects.requireNonNull(pageRequest, "pageRequest");
    }

    public T getData() {
        return this.data;
    }

    public Optional<PageRequest> getNextPageRequest() {
        long nextPageStart = this.pageRequest.getStart() + (long)this.pageRequest.getLimit();
        if (nextPageStart < this.totalHits) {
            return Optional.of(PageRequest.of(nextPageStart, this.pageRequest.getLimit()));
        }
        return Optional.empty();
    }

    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public long getTotalHits() {
        return this.totalHits;
    }
}

