/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.request;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.field.NestedField;
import com.atlassian.jira.search.request.AbstractSearchRequestBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

@Internal
public class GetRequest {
    private final Collection<Field> fields;
    private final Map<NestedField, Collection<Field>> nestedFields;
    private final String id;

    private GetRequest(Builder builder) {
        this.fields = builder.fields.build();
        this.id = builder.id;
        ImmutableMap.Builder nestedBuilder = ImmutableMap.builder();
        builder.nestedFields.forEach((key, value) -> nestedBuilder.put(key, (Object)value.build()));
        this.nestedFields = nestedBuilder.build();
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public Collection<Field> getFields() {
        return this.fields;
    }

    public Map<NestedField, Collection<Field>> getNestedFields() {
        return this.nestedFields;
    }

    public String getId() {
        return this.id;
    }

    public static class Builder
    extends AbstractSearchRequestBuilder<Builder> {
        private final String id;

        public Builder(String id) {
            this.id = Objects.requireNonNull(id, "id");
        }

        public GetRequest build() {
            return new GetRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

