/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.index;

import com.atlassian.jira.search.Document;
import java.util.Objects;
import java.util.Optional;

public final class IndexRequest {
    private final String documentId;
    private final Long documentVersion;
    private final Document document;

    private IndexRequest(Builder builder) {
        this.documentId = builder.documentId;
        this.documentVersion = builder.documentVersion;
        this.document = builder.document;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public Optional<Long> getDocumentVersion() {
        return Optional.ofNullable(this.documentVersion);
    }

    public Document getDocument() {
        return this.document;
    }

    public static Builder builder(String documentId, Document doc) {
        return new Builder(documentId, doc);
    }

    public static Builder builder(String documentId, long version, Document document) {
        return new Builder(documentId, version, document);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexRequest that = (IndexRequest)o;
        return Objects.equals(this.documentId, that.documentId) && Objects.equals(this.documentVersion, that.documentVersion);
    }

    public int hashCode() {
        return Objects.hash(this.documentId, this.documentVersion);
    }

    public static class Builder {
        private final String documentId;
        private Long documentVersion;
        private final Document document;

        public Builder(String documentId, Document document) {
            this.documentId = Objects.requireNonNull(documentId, "documentId");
            this.document = Objects.requireNonNull(document, "doc");
        }

        public Builder(String documentId, long documentVersion, Document document) {
            this.documentId = Objects.requireNonNull(documentId, "documentId");
            this.documentVersion = documentVersion;
            this.document = Objects.requireNonNull(document, "doc");
        }

        public Builder version(long documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public IndexRequest build() {
            return new IndexRequest(this);
        }
    }
}

