/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.keyboardshortcut;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@PublicApi
public final class KeyboardShortcut
implements Comparable<KeyboardShortcut> {
    private static final String START_TAG = "<kbd>";
    private static final String END_TAG = "</kbd>";
    private static final Condition ALWAYS_DISPLAY_CONDITION = new Condition(){

        public void init(Map<String, String> params) throws PluginParseException {
        }

        public boolean shouldDisplay(Map<String, Object> context) {
            return true;
        }
    };
    private final String moduleKey;
    private final KeyboardShortcutManager.Context context;
    private final KeyboardShortcutManager.Operation operation;
    private final String parameter;
    private final int order;
    private final Set<List<String>> shortcuts;
    private final String descriptionI18nKey;
    private final boolean hidden;
    private final Condition condition;

    public KeyboardShortcut(String moduleKey, KeyboardShortcutManager.Context context, KeyboardShortcutManager.Operation operation, String parameter, int order, Set<List<String>> shortcuts, String descriptionI18nKey, boolean hidden) {
        this(moduleKey, context, operation, parameter, order, shortcuts, descriptionI18nKey, hidden, ALWAYS_DISPLAY_CONDITION);
    }

    public KeyboardShortcut(String moduleKey, KeyboardShortcutManager.Context context, KeyboardShortcutManager.Operation operation, String parameter, int order, Set<List<String>> shortcuts, String descriptionI18nKey, boolean hidden, Condition condition) {
        this.moduleKey = Assertions.notNull("moduleKey", moduleKey);
        this.context = Assertions.notNull("context", context);
        this.operation = Assertions.notNull("operation", operation);
        this.parameter = Assertions.notNull("parameter", parameter);
        this.order = order;
        this.shortcuts = new LinkedHashSet<List<String>>((Collection)Assertions.notNull("shortcuts", shortcuts));
        this.descriptionI18nKey = descriptionI18nKey;
        this.hidden = hidden;
        this.condition = Assertions.notNull("condition", condition);
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public KeyboardShortcutManager.Context getContext() {
        return this.context;
    }

    public KeyboardShortcutManager.Operation getOperation() {
        return this.operation;
    }

    public String getParameter() {
        return this.parameter;
    }

    public int getOrder() {
        return this.order;
    }

    public Set<List<String>> getShortcuts() {
        return this.shortcuts;
    }

    public String getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.condition.shouldDisplay(context);
    }

    public String getPrettyShortcut(I18nHelper i18nHelper) {
        StringBuilder ret = new StringBuilder();
        int count = 0;
        for (List<String> shortcut : this.shortcuts) {
            if (count > 0) {
                ret.append(" ").append(i18nHelper.getText("common.words.or")).append(" ");
            }
            if (shortcut.size() == 2) {
                ret.append(i18nHelper.getText("keyboard.shortcuts.two.keys", START_TAG + shortcut.get(0) + END_TAG, START_TAG + shortcut.get(1) + END_TAG));
            } else if (shortcut.size() == 3) {
                ret.append(i18nHelper.getText("keyboard.shortcuts.three.keys", START_TAG + shortcut.get(0) + END_TAG, START_TAG + shortcut.get(1) + END_TAG, START_TAG + shortcut.get(2) + END_TAG));
            } else {
                ret.append(START_TAG).append(StringUtils.join(shortcut, (String)" ")).append(END_TAG);
            }
            ++count;
        }
        return ret.toString();
    }

    @Override
    public int compareTo(KeyboardShortcut shortcut) {
        int order2 = shortcut.getOrder();
        if (this.order == order2) {
            return 0;
        }
        if (this.order < order2) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return "KeyboardShortcut{context=" + String.valueOf((Object)this.context) + ", shortcuts=" + String.valueOf(this.shortcuts) + ", operation=" + String.valueOf((Object)this.operation) + ", parameter='" + this.parameter + "', descriptionI18nKey='" + this.descriptionI18nKey + "', order=" + this.order + ", hidden=" + this.hidden + ", condition=" + String.valueOf(this.condition) + "}";
    }
}

