/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanHelper;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.JiraUrlCodec;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Options;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CommentJsonBean {
    private static final String EXPAND_RENDERED_BODY = "renderedBody";
    private static final String EXPAND_PROPERTIES = "properties";
    @JsonProperty
    @Schema(example="http://www.example.com/jira/rest/api/2/issue/10010/comment/10000")
    private String self;
    @JsonProperty
    @Schema(example="10000")
    private String id;
    @JsonProperty
    private UserJsonBean author;
    @JsonProperty
    @Schema(example="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper.")
    private String body;
    @JsonProperty
    @Schema(example="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper.")
    private String renderedBody;
    @JsonProperty
    private UserJsonBean updateAuthor;
    @JsonProperty
    @Schema(example="2012-07-06T18:30:00.000+0000")
    private String created;
    @JsonProperty
    @Schema(example="2012-07-06T18:30:00.000+0000")
    private String updated;
    @JsonProperty
    private VisibilityJsonBean visibility;
    @JsonIgnore
    private boolean isVisibilitySet = false;
    @JsonIgnore
    private boolean isBodySet = false;
    private List<EntityPropertyBean> properties;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public UserJsonBean getAuthor() {
        return this.author;
    }

    public void setAuthor(UserJsonBean author) {
        this.author = author;
    }

    public String getBody() {
        return this.body;
    }

    public String getRenderedBody() {
        return this.renderedBody;
    }

    public void setRenderedBody(String renderedBody) {
        this.renderedBody = renderedBody;
    }

    public void setBody(String body) {
        this.body = body;
        this.isBodySet = true;
    }

    public UserJsonBean getUpdateAuthor() {
        return this.updateAuthor;
    }

    public void setUpdateAuthor(UserJsonBean updateAuthor) {
        this.updateAuthor = updateAuthor;
    }

    public Date getCreated() {
        return Dates.fromTimeString(this.created);
    }

    @JsonGetter(value="created")
    public String getCreatedString() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = Dates.asTimeString(created);
    }

    public Date getUpdated() {
        return Dates.fromTimeString(this.updated);
    }

    @JsonGetter(value="updated")
    public String getUpdatedString() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = Dates.asTimeString(updated);
    }

    @JsonIgnore
    public boolean isBodySet() {
        return this.isBodySet;
    }

    @JsonIgnore
    public boolean isVisibilitySet() {
        return this.isVisibilitySet;
    }

    @JsonProperty
    public VisibilityJsonBean getVisibility() {
        return this.visibility;
    }

    @JsonProperty
    public void setVisibility(VisibilityJsonBean visibility) {
        this.visibility = visibility;
        this.isVisibilitySet = true;
    }

    @JsonProperty
    public List<EntityPropertyBean> getProperties() {
        return this.properties;
    }

    @JsonProperty
    public void setProperties(List<Map<String, Object>> properties) {
        this.properties = EntityPropertyBeanHelper.createFrom(properties);
    }

    @Deprecated
    public static Collection<CommentJsonBean> shortBeans(Collection<Comment> comments, JiraBaseUrls urls, ProjectRoleManager projectRoleManager) {
        return CommentJsonBean.shortBeans(comments, urls, projectRoleManager, CommentJsonBean.getLoggedInUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static Collection<CommentJsonBean> shortBeans(Collection<Comment> comments, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        ArrayList result = Lists.newArrayListWithCapacity((int)comments.size());
        for (Comment from : comments) {
            result.add(CommentJsonBean.shortBean(from, urls, projectRoleManager, loggedInUser, emailFormatter));
        }
        return result;
    }

    @Deprecated
    public static CommentJsonBean shortBean(Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager) {
        return CommentJsonBean.shortBean(comment, urls, projectRoleManager, CommentJsonBean.getLoggedInUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static CommentJsonBean shortBean(Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        if (comment == null) {
            return null;
        }
        CommentJsonBean bean = new CommentJsonBean();
        CommentJsonBean.addNonRenderableStuff(bean, comment, urls, projectRoleManager, loggedInUser, emailFormatter);
        bean.body = comment.getBody();
        bean.setCreated(comment.getCreated());
        bean.setUpdated(comment.getUpdated());
        return bean;
    }

    @Deprecated
    public static Collection<CommentJsonBean> renderedShortBeans(Collection<Comment> comments, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, String rendererType, IssueRenderContext renderContext) {
        return CommentJsonBean.renderedShortBeans(comments, urls, projectRoleManager, dateTimeFormatterFactory, rendererManager, rendererType, renderContext, CommentJsonBean.getLoggedInUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static Collection<CommentJsonBean> renderedShortBeans(Collection<Comment> comments, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, String rendererType, IssueRenderContext renderContext, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        ArrayList result = Lists.newArrayListWithCapacity((int)comments.size());
        for (Comment from : comments) {
            result.add(CommentJsonBean.renderedShortBean(from, urls, projectRoleManager, dateTimeFormatterFactory, rendererManager, rendererType, renderContext, loggedInUser, emailFormatter));
        }
        return Lists.newArrayList((Iterable)result);
    }

    @Deprecated
    public static Collection<CommentJsonBean> expandedShortBeans(Collection<Comment> comments, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, String rendererType, IssueRenderContext renderContext, String expand) {
        return CommentJsonBean.expandedShortBeans(comments, urls, projectRoleManager, dateTimeFormatterFactory, rendererManager, rendererType, renderContext, expand, CommentJsonBean.getLoggedInUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static Collection<CommentJsonBean> expandedShortBeans(Collection<Comment> comments, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, String rendererType, IssueRenderContext renderContext, String expand, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        ArrayList result = Lists.newArrayListWithCapacity((int)comments.size());
        for (Comment from : comments) {
            result.add(CommentJsonBean.expandedShortBean(from, urls, projectRoleManager, dateTimeFormatterFactory, rendererManager, rendererType, renderContext, expand, loggedInUser, emailFormatter));
        }
        return Lists.newArrayList((Iterable)result);
    }

    @Deprecated
    public static CommentJsonBean renderedShortBean(Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, String rendererType, IssueRenderContext renderContext) {
        return CommentJsonBean.renderedShortBean(comment, urls, projectRoleManager, dateTimeFormatterFactory, rendererManager, rendererType, renderContext, CommentJsonBean.getLoggedInUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    private static ApplicationUser getLoggedInUser() {
        return ComponentAccessor.getComponent(JiraAuthenticationContext.class).getLoggedInUser();
    }

    public static CommentJsonBean renderedShortBean(Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, String rendererType, IssueRenderContext renderContext, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        if (comment == null) {
            return null;
        }
        CommentJsonBean bean = new CommentJsonBean();
        CommentJsonBean.addNonRenderableStuff(bean, comment, urls, projectRoleManager, loggedInUser, emailFormatter);
        bean.body = StringUtils.isNotBlank((CharSequence)rendererType) ? rendererManager.getRenderedContent(rendererType, comment.getBody(), renderContext) : comment.getBody();
        bean.created = comment.getCreated() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(comment.getCreated());
        bean.updated = comment.getUpdated() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(comment.getUpdated());
        return bean;
    }

    @Deprecated
    public static CommentJsonBean expandedShortBean(Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, String rendererType, IssueRenderContext renderContext, String expand) {
        return CommentJsonBean.expandedShortBean(comment, urls, projectRoleManager, dateTimeFormatterFactory, rendererManager, rendererType, renderContext, expand, CommentJsonBean.getLoggedInUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static CommentJsonBean expandedShortBean(Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, String rendererType, IssueRenderContext renderContext, String expand, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        if (comment == null) {
            return null;
        }
        CommentJsonBean bean = new CommentJsonBean();
        CommentJsonBean.addNonRenderableStuff(bean, comment, urls, projectRoleManager, loggedInUser, emailFormatter);
        if (StringUtils.isNotBlank((CharSequence)rendererType)) {
            bean.body = comment.getBody();
            if (expand.contains(EXPAND_RENDERED_BODY)) {
                bean.renderedBody = rendererManager.getRenderedContent(rendererType, comment.getBody(), renderContext);
            }
        } else {
            bean.body = comment.getBody();
            if (expand.contains(EXPAND_RENDERED_BODY)) {
                bean.renderedBody = comment.getBody();
            }
        }
        if (expand.contains(EXPAND_PROPERTIES)) {
            bean.properties = CommentJsonBean.getProperties(comment, urls);
        }
        bean.setCreated(comment.getCreated());
        bean.setUpdated(comment.getUpdated());
        return bean;
    }

    private static List<EntityPropertyBean> getProperties(Comment comment, JiraBaseUrls urls) {
        ApplicationUser applicationUser = CommentJsonBean.getLoggedInUser();
        CommentPropertyService commentPropertyService = ComponentAccessor.getComponent(CommentPropertyService.class);
        EntityPropertyService.PropertyKeys keys = commentPropertyService.getPropertiesKeys(applicationUser, comment.getId());
        Iterable propertyBeans = keys.getKeys().stream().map(key -> {
            EntityPropertyService.PropertyResult property = commentPropertyService.getProperty(applicationUser, comment.getId(), (String)key);
            return Option.option((Object)((EntityPropertyBean)property.getEntityProperty().fold(() -> null, CommentJsonBean.buildPropertyBean(comment, urls, key))));
        }).collect(Collectors.toList());
        return Lists.newArrayList((Iterable)Options.flatten((Iterable)propertyBeans));
    }

    private static Function<EntityProperty, EntityPropertyBean> buildPropertyBean(Comment comment, JiraBaseUrls urls, String key) {
        return entityProperty -> EntityPropertyBean.builder(urls, new EntityPropertyBeanSelfFunctions.CommentPropertySelfBifFunction()).key(key).value(entityProperty.getValue()).build(comment.getId());
    }

    private static void addNonRenderableStuff(CommentJsonBean bean, @Nonnull Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        UserBeanFactory userBeanFactory = ComponentAccessor.getComponent(UserBeanFactory.class);
        bean.self = urls.restApi2BaseUrl() + "issue/" + comment.getIssue().getId() + "/comment/" + JiraUrlCodec.encode(comment.getId().toString());
        bean.id = comment.getId().toString();
        bean.author = userBeanFactory.createBean(comment.getAuthorApplicationUser(), loggedInUser, urls, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
        bean.updateAuthor = userBeanFactory.createBean(comment.getUpdateAuthorApplicationUser(), loggedInUser, urls, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
        bean.visibility = CommentJsonBean.getVisibilityBean(comment, projectRoleManager);
    }

    private static VisibilityJsonBean getVisibilityBean(Comment comment, ProjectRoleManager projectRoleManager) {
        VisibilityJsonBean visibilityBean = null;
        String groupLevel = comment.getGroupLevel();
        if (groupLevel != null) {
            visibilityBean = new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.group, groupLevel);
        } else {
            Long roleId = comment.getRoleLevelId();
            if (roleId != null) {
                String roleName = projectRoleManager.getProjectRole(roleId).getName();
                visibilityBean = new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.role, roleName);
            }
        }
        return visibilityBean;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("self", (Object)this.self).append("id", (Object)this.id).append("author", (Object)this.author).append("body", (Object)this.body).append(EXPAND_RENDERED_BODY, (Object)this.renderedBody).append("updateAuthor", (Object)this.updateAuthor).append("created", (Object)this.created).append("updated", (Object)this.updated).append("visibility", (Object)this.visibility).append("isVisibilitySet", this.isVisibilitySet).append("isBodySet", this.isBodySet).append(EXPAND_PROPERTIES, this.properties).toString();
    }
}

