/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dashboard;

import com.atlassian.annotations.PublicApi;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class DashboardItemLocator {
    private final DashboardId dashboardId;
    private final GadgetId gadgetId;

    private DashboardItemLocator(@Nonnull DashboardId dashboardId, @Nonnull GadgetId gadgetId) {
        this.dashboardId = (DashboardId)Preconditions.checkNotNull((Object)dashboardId);
        this.gadgetId = (GadgetId)Preconditions.checkNotNull((Object)gadgetId);
    }

    public static DashboardItemLocator itemLocator(@Nonnull String dashboardId, @Nonnull String itemId) {
        return new DashboardItemLocator(DashboardId.valueOf((String)((String)Preconditions.checkNotNull((Object)dashboardId))), GadgetId.valueOf((String)((String)Preconditions.checkNotNull((Object)itemId))));
    }

    public static DashboardItemLocator itemLocator(@Nonnull DashboardId dashboardId, @Nonnull GadgetId itemId) {
        return new DashboardItemLocator(dashboardId, itemId);
    }

    public DashboardId getDashboardId() {
        return this.dashboardId;
    }

    public GadgetId getGadgetId() {
        return this.gadgetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardItemLocator that = (DashboardItemLocator)o;
        if (!this.dashboardId.equals((Object)that.dashboardId)) {
            return false;
        }
        return this.gadgetId.equals((Object)that.gadgetId);
    }

    public int hashCode() {
        int result = this.dashboardId.hashCode();
        result = 31 * result + this.gadgetId.hashCode();
        return result;
    }

    public String toString() {
        return String.valueOf(this.dashboardId) + "/" + String.valueOf(this.gadgetId);
    }
}

