/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.type;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.event.type.EventType;
import javax.annotation.Nullable;

@PublicApi
public interface EventDispatchOption {
    public static final EventDispatchOption DO_NOT_DISPATCH = Factory.get(null);
    public static final EventDispatchOption ISSUE_UPDATED = Factory.get(EventType.ISSUE_UPDATED_ID);
    public static final EventDispatchOption ISSUE_ASSIGNED = Factory.get(EventType.ISSUE_ASSIGNED_ID);
    public static final EventDispatchOption ISSUE_DELETED = Factory.get(EventType.ISSUE_DELETED_ID);
    public static final EventDispatchOption ISSUE_ARCHIVED = Factory.get(EventType.ISSUE_ARCHIVED_ID);
    public static final EventDispatchOption ISSUE_RESTORED = Factory.get(EventType.ISSUE_RESTORED_ID);

    public boolean isEventBeingSent();

    public Long getEventTypeId();

    public static final class Factory {
        private static EventDispatchOption DO_NOT_DISPATCH = new EventDispatchOptionImpl();

        public static EventDispatchOption get(@Nullable Long id) {
            if (id == null) {
                return DO_NOT_DISPATCH;
            }
            return new EventDispatchOptionImpl(id);
        }
    }

    public static class EventDispatchOptionImpl
    implements EventDispatchOption {
        private final Long eventTypeId;

        private EventDispatchOptionImpl() {
            this.eventTypeId = null;
        }

        private EventDispatchOptionImpl(Long eventTypeId) {
            this.eventTypeId = eventTypeId;
        }

        @Override
        public boolean isEventBeingSent() {
            return this.eventTypeId != null;
        }

        @Override
        public Long getEventTypeId() {
            return this.eventTypeId;
        }
    }
}

