/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.operator;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.Predicate;
import java.util.Comparator;
import javax.annotation.concurrent.Immutable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Immutable
@PublicApi
public enum Operator {
    LIKE("~"),
    NOT_LIKE("!~"),
    EQUALS("="),
    NOT_EQUALS("!="),
    IN("in"),
    NOT_IN("not in"),
    IS("is"),
    IS_NOT("is not"),
    LESS_THAN("<"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            return input -> comparator.compare(input, operand) < 0;
        }
    }
    ,
    LESS_THAN_EQUALS("<="){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            return input -> comparator.compare(input, operand) <= 0;
        }
    }
    ,
    GREATER_THAN(">"){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
            return input -> comparator.compare(input, operand) > 0;
        }
    }
    ,
    GREATER_THAN_EQUALS(">="){

        @Override
        public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T value) {
            return input -> comparator.compare(input, value) >= 0;
        }
    }
    ,
    WAS("was"),
    WAS_NOT("was not"),
    WAS_IN("was in"),
    WAS_NOT_IN("was not in"),
    CHANGED("changed"),
    NOT_CHANGED("not changed"),
    BEFORE("before"),
    AFTER("after"),
    FROM("from"),
    TO("to"),
    ON("on"),
    DURING("during"),
    BY("by");

    private final String displayName;

    private Operator(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayString() {
        return this.displayName;
    }

    public <T> Predicate<T> getPredicateForValue(Comparator<? super T> comparator, T operand) {
        throw new IllegalStateException("You cannot get a predicate for the '" + this.displayName + "' operator.");
    }
}

