/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import java.util.Arrays;

public class FileNameCharacterCheckerUtil {
    private static final char[] INVALID_CHARS = new char[]{'/', '\\', '?', '*', ':', '|', '\"', '<', '>', '\r', '\n', '\t', '\u0000'};

    public String assertFileNameDoesNotContainInvalidChars(String filename) {
        if (filename == null) {
            return null;
        }
        for (char invalidChar : INVALID_CHARS) {
            if (filename.indexOf(invalidChar) == -1) continue;
            return String.valueOf(invalidChar);
        }
        return null;
    }

    public String replaceInvalidChars(String filename, char replacementChar) {
        if (this.assertFileNameDoesNotContainInvalidChars(String.valueOf(replacementChar)) != null) {
            throw new IllegalArgumentException("Replacement character '" + replacementChar + "' is invalid");
        }
        if (filename == null) {
            return null;
        }
        for (char invalidChar : INVALID_CHARS) {
            filename = filename.replace(invalidChar, replacementChar);
        }
        return filename;
    }

    public String getPrintableInvalidCharacters() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            char invalidChar = INVALID_CHARS[i];
            sb.append("'");
            sb.append(invalidChar);
            sb.append("'");
            if (i + 1 >= INVALID_CHARS.length) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static char[] getInvalidCharacters() {
        return Arrays.copyOf(INVALID_CHARS, INVALID_CHARS.length);
    }
}

