/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.annotations.PublicApi;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class UserIdentity {
    private final Long id;
    private final String key;
    private final String username;

    private UserIdentity(Long id, String key, String username) {
        this.id = (Long)Preconditions.checkNotNull((Object)id);
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.username = (String)Preconditions.checkNotNull((Object)username);
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getUsername() {
        return this.username;
    }

    public static BuilderWithId withId(Long id) {
        return new BuilderWithId(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserIdentity that = (UserIdentity)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.username, (Object)that.username);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.key, this.username});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("key", (Object)this.key).add("username", (Object)this.username).toString();
    }

    public static class BuilderWithId {
        private final Long id;

        private BuilderWithId(Long id) {
            this.id = (Long)Preconditions.checkNotNull((Object)id);
        }

        public BuilderWithIdAndKey key(String key) {
            return new BuilderWithIdAndKey(this.id, key);
        }
    }

    public static class BuilderWithIdAndKey {
        private final Long id;
        private final String key;

        private BuilderWithIdAndKey(Long id, String key) {
            this.id = (Long)Preconditions.checkNotNull((Object)id);
            this.key = (String)Preconditions.checkNotNull((Object)key);
        }

        public UserIdentity andUsername(String username) {
            return new UserIdentity(this.id, this.key, username);
        }
    }
}

