/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.query;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.query.BooleanQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Internal
public class DefaultBooleanQuery
implements BooleanQuery {
    private final List<BooleanQuery.Clause> clauses;
    private final int minimumShouldMatch;

    private DefaultBooleanQuery(Builder builder) {
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.clauses = new ArrayList<BooleanQuery.Clause>(builder.clauses);
    }

    @Override
    public List<BooleanQuery.Clause> clauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    @Override
    public int minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public static BooleanQuery.Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultBooleanQuery that = (DefaultBooleanQuery)o;
        return this.minimumShouldMatch == that.minimumShouldMatch && Objects.equals(this.clauses, that.clauses);
    }

    public int hashCode() {
        return Objects.hash(this.clauses, this.minimumShouldMatch);
    }

    public static class Builder
    implements BooleanQuery.Builder {
        private final List<BooleanQuery.Clause> clauses = new ArrayList<BooleanQuery.Clause>();
        private int minimumShouldMatch = 0;

        @Override
        public BooleanQuery.Builder add(Query query, BooleanQuery.Occur occur) {
            this.clauses.add(new DefaultClause(occur, query));
            return this;
        }

        @Override
        public BooleanQuery.Builder minimumShouldMatch(int k) {
            this.minimumShouldMatch = k;
            return this;
        }

        @Override
        public BooleanQuery build() {
            return new DefaultBooleanQuery(this);
        }
    }

    private static final class DefaultClause
    implements BooleanQuery.Clause {
        private final BooleanQuery.Occur occur;
        private final Query query;

        private DefaultClause(BooleanQuery.Occur occur, Query query) {
            this.occur = Objects.requireNonNull(occur, "occur");
            this.query = Objects.requireNonNull(query, "query");
        }

        @Override
        public BooleanQuery.Occur occur() {
            return this.occur;
        }

        @Override
        public Query query() {
            return this.query;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DefaultClause that = (DefaultClause)obj;
            return Objects.equals((Object)this.occur, (Object)that.occur) && Objects.equals(this.query, that.query);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.occur, this.query});
        }

        public String toString() {
            return "DefaultClause[occur=" + String.valueOf((Object)this.occur) + ", query=" + String.valueOf(this.query) + "]";
        }
    }
}

