/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Document;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.FieldVisitor;
import com.atlassian.jira.search.Schema;
import com.atlassian.jira.search.field.FieldValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Internal
public class NestedField
implements Field {
    private final String name;
    private final Schema schema;

    public NestedField(String name, Schema schema) {
        this.name = Objects.requireNonNull(name, "name");
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    @Override
    public <T> Optional<T> accept(FieldVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public FieldValue create(Document value) {
        return new FieldValue(this, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NestedField)) {
            return false;
        }
        NestedField that = (NestedField)o;
        return Objects.equals(this.name, that.name);
    }

    public List<Document> get(Document doc) {
        return doc.getValues(this);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    public boolean isStored() {
        return true;
    }

    public String toString() {
        return "NestedField{name=" + this.name + ", schema=" + String.valueOf(this.schema) + "}";
    }
}

